@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * IP Group properties.
 * @property ipAddressType IP Address type.
 * @property ipPrefixes List of IP Prefixes.
 * @property name IP Group name.
 */
public data class IpGroupPropertiesResponse(
    public val ipAddressType: String? = null,
    public val ipPrefixes: List<String>? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.IpGroupPropertiesResponse):
            IpGroupPropertiesResponse = IpGroupPropertiesResponse(
            ipAddressType = javaType.ipAddressType().map({ args0 -> args0 }).orElse(null),
            ipPrefixes = javaType.ipPrefixes().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
