@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the condition that can be filtered using the selected IPs.
 * @property ipGroupNames The List of IP Group Names that need to be matched.
 * @property ipPrefixValues The list of IP Prefixes that need to be matched.
 * @property prefixType IP Prefix Type that needs to be matched.
 * @property type IP Address type that needs to be matched.
 */
public data class IpMatchConditionResponse(
    public val ipGroupNames: List<String>? = null,
    public val ipPrefixValues: List<String>? = null,
    public val prefixType: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.IpMatchConditionResponse):
            IpMatchConditionResponse = IpMatchConditionResponse(
            ipGroupNames = javaType.ipGroupNames().map({ args0 -> args0 }),
            ipPrefixValues = javaType.ipPrefixValues().map({ args0 -> args0 }),
            prefixType = javaType.prefixType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
