@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the match configuration that are supported to filter the traffic.
 * @property actions List of actions that need to be performed for the matched conditions.
 * @property ipAddressType Type of IP Address. IPv4 or IPv6
 * @property matchConditions List of the match conditions.
 * @property matchConfigurationName The name of the match configuration.
 * @property sequenceNumber Sequence Number of the match configuration..
 */
public data class NetworkTapRuleMatchConfigurationResponse(
    public val actions: List<NetworkTapRuleActionResponse>? = null,
    public val ipAddressType: String? = null,
    public val matchConditions: List<NetworkTapRuleMatchConditionResponse>? = null,
    public val matchConfigurationName: String? = null,
    public val sequenceNumber: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.NetworkTapRuleMatchConfigurationResponse):
            NetworkTapRuleMatchConfigurationResponse = NetworkTapRuleMatchConfigurationResponse(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NetworkTapRuleActionResponse.Companion.toKotlin(args0)
                })
            }),
            ipAddressType = javaType.ipAddressType().map({ args0 -> args0 }).orElse(null),
            matchConditions = javaType.matchConditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NetworkTapRuleMatchConditionResponse.Companion.toKotlin(args0)
                })
            }),
            matchConfigurationName = javaType.matchConfigurationName().map({ args0 -> args0 }).orElse(null),
            sequenceNumber = javaType.sequenceNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
