@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Route Policy Statement properties..
 * @property action Route policy action properties.
 * @property annotation Switch configuration description.
 * @property condition Route policy condition properties.
 * @property sequenceNumber Sequence to insert to/delete from existing route.
 */
public data class RoutePolicyStatementPropertiesResponse(
    public val action: StatementActionPropertiesResponse,
    public val `annotation`: String? = null,
    public val condition: StatementConditionPropertiesResponse,
    public val sequenceNumber: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.RoutePolicyStatementPropertiesResponse):
            RoutePolicyStatementPropertiesResponse = RoutePolicyStatementPropertiesResponse(
            action = javaType.action().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.StatementActionPropertiesResponse.Companion.toKotlin(args0)
            }),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            condition = javaType.condition().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.StatementConditionPropertiesResponse.Companion.toKotlin(args0)
            }),
            sequenceNumber = javaType.sequenceNumber(),
        )
    }
}
