@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rules for the InternetGateways
 * @property action Specify action.
 * @property addressList List of Addresses to be allowed or denied.
 */
public data class RulePropertiesResponse(
    public val action: String,
    public val addressList: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.RulePropertiesResponse):
            RulePropertiesResponse = RulePropertiesResponse(
            action = javaType.action(),
            addressList = javaType.addressList().map({ args0 -> args0 }),
        )
    }
}
