@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.EligibleApproverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the Azure Active Directory principal that can approve any just-in-time access requests by the principal defined in the EligibleAuthorization.
 * @property principalId The identifier of the Azure Active Directory principal.
 * @property principalIdDisplayName The display name of the Azure Active Directory principal.
 */
public data class EligibleApproverArgs(
    public val principalId: Output<String>,
    public val principalIdDisplayName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.EligibleApproverArgs> {
    override fun toJava(): com.pulumi.azurenative.managedservices.inputs.EligibleApproverArgs =
        com.pulumi.azurenative.managedservices.inputs.EligibleApproverArgs.builder()
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .principalIdDisplayName(principalIdDisplayName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EligibleApproverArgs].
 */
@PulumiTagMarker
public class EligibleApproverArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var principalIdDisplayName: Output<String>? = null

    /**
     * @param value The identifier of the Azure Active Directory principal.
     */
    @JvmName("npgjywrsqsxsqbpy")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The display name of the Azure Active Directory principal.
     */
    @JvmName("penhojxeylxosdyc")
    public suspend fun principalIdDisplayName(`value`: Output<String>) {
        this.principalIdDisplayName = value
    }

    /**
     * @param value The identifier of the Azure Active Directory principal.
     */
    @JvmName("gslwnbcbhdqhkody")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The display name of the Azure Active Directory principal.
     */
    @JvmName("akfhkqcqspwycrju")
    public suspend fun principalIdDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalIdDisplayName = mapped
    }

    internal fun build(): EligibleApproverArgs = EligibleApproverArgs(
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        principalIdDisplayName = principalIdDisplayName,
    )
}
