@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.GetRegistrationAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expandRegistrationDefinition The flag indicating whether to return the registration definition details along with the registration assignment details.
 * @property registrationAssignmentId The GUID of the registration assignment.
 * @property scope The scope of the resource.
 */
public data class GetRegistrationAssignmentPlainArgs(
    public val expandRegistrationDefinition: Boolean? = null,
    public val registrationAssignmentId: String,
    public val scope: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.GetRegistrationAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managedservices.inputs.GetRegistrationAssignmentPlainArgs =
        com.pulumi.azurenative.managedservices.inputs.GetRegistrationAssignmentPlainArgs.builder()
            .expandRegistrationDefinition(expandRegistrationDefinition?.let({ args0 -> args0 }))
            .registrationAssignmentId(registrationAssignmentId.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistrationAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetRegistrationAssignmentPlainArgsBuilder internal constructor() {
    private var expandRegistrationDefinition: Boolean? = null

    private var registrationAssignmentId: String? = null

    private var scope: String? = null

    /**
     * @param value The flag indicating whether to return the registration definition details along with the registration assignment details.
     */
    @JvmName("wxoflebermkmdanu")
    public suspend fun expandRegistrationDefinition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expandRegistrationDefinition = mapped
    }

    /**
     * @param value The GUID of the registration assignment.
     */
    @JvmName("vrchkjtgkoosftcj")
    public suspend fun registrationAssignmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registrationAssignmentId = mapped
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("mcekqlfpuxvfyfix")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetRegistrationAssignmentPlainArgs = GetRegistrationAssignmentPlainArgs(
        expandRegistrationDefinition = expandRegistrationDefinition,
        registrationAssignmentId = registrationAssignmentId ?: throw
            PulumiNullFieldException("registrationAssignmentId"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
