@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.GetRegistrationDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registrationDefinitionId The GUID of the registration definition.
 * @property scope The scope of the resource.
 */
public data class GetRegistrationDefinitionPlainArgs(
    public val registrationDefinitionId: String,
    public val scope: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.GetRegistrationDefinitionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managedservices.inputs.GetRegistrationDefinitionPlainArgs =
        com.pulumi.azurenative.managedservices.inputs.GetRegistrationDefinitionPlainArgs.builder()
            .registrationDefinitionId(registrationDefinitionId.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistrationDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetRegistrationDefinitionPlainArgsBuilder internal constructor() {
    private var registrationDefinitionId: String? = null

    private var scope: String? = null

    /**
     * @param value The GUID of the registration definition.
     */
    @JvmName("nxwfuiipsfigiovp")
    public suspend fun registrationDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registrationDefinitionId = mapped
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("pmwncwxonfnvwrwr")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetRegistrationDefinitionPlainArgs = GetRegistrationDefinitionPlainArgs(
        registrationDefinitionId = registrationDefinitionId ?: throw
            PulumiNullFieldException("registrationDefinitionId"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
