@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin

import com.pulumi.azurenative.management.kotlin.outputs.DescendantParentGroupInfoResponse
import com.pulumi.azurenative.management.kotlin.outputs.DescendantParentGroupInfoResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagementGroupSubscription].
 */
@PulumiTagMarker
public class ManagementGroupSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagementGroupSubscriptionArgs = ManagementGroupSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagementGroupSubscriptionArgsBuilder.() -> Unit) {
        val builder = ManagementGroupSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagementGroupSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.management.ManagementGroupSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagementGroupSubscription(builtJavaResource)
    }
}

/**
 * The details of subscription under management group.
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2023-04-01.
 * ## Example Usage
 * ### AddSubscriptionToManagementGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroupSubscription = new AzureNative.Management.ManagementGroupSubscription("managementGroupSubscription", new()
 *     {
 *         GroupId = "Group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/management/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := management.NewManagementGroupSubscription(ctx, "managementGroupSubscription", &management.ManagementGroupSubscriptionArgs{
 * 			GroupId: pulumi.String("Group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.management.ManagementGroupSubscription;
 * import com.pulumi.azurenative.management.ManagementGroupSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroupSubscription = new ManagementGroupSubscription("managementGroupSubscription", ManagementGroupSubscriptionArgs.builder()
 *             .groupId("Group")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:management:ManagementGroupSubscription 728bcbe4-8d56-4510-86c2-4921b8beefbc /providers/Microsoft.Management/managementGroups/{groupId}/subscriptions/{subscriptionId}
 * ```
 */
public class ManagementGroupSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.management.ManagementGroupSubscription,
) : KotlinCustomResource(javaResource, ManagementGroupSubscriptionMapper) {
    /**
     * The friendly name of the subscription.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The stringified id of the subscription. For example, 00000000-0000-0000-0000-000000000000
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the parent management group.
     */
    public val parent: Output<DescendantParentGroupInfoResponse>?
        get() = javaResource.parent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The state of the subscription.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The AAD Tenant ID associated with the subscription. For example, 00000000-0000-0000-0000-000000000000
     */
    public val tenant: Output<String>?
        get() = javaResource.tenant().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.  For example, Microsoft.Management/managementGroups/subscriptions
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagementGroupSubscriptionMapper : ResourceMapper<ManagementGroupSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.management.ManagementGroupSubscription::class == javaResource::class

    override fun map(javaResource: Resource): ManagementGroupSubscription =
        ManagementGroupSubscription(
            javaResource as
                com.pulumi.azurenative.management.ManagementGroupSubscription,
        )
}

/**
 * @see [ManagementGroupSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagementGroupSubscription].
 */
public suspend fun managementGroupSubscription(
    name: String,
    block: suspend ManagementGroupSubscriptionResourceBuilder.() -> Unit,
):
    ManagementGroupSubscription {
    val builder = ManagementGroupSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagementGroupSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managementGroupSubscription(name: String): ManagementGroupSubscription {
    val builder = ManagementGroupSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
