@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managementpartner.kotlin.inputs

import com.pulumi.azurenative.managementpartner.inputs.GetPartnerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partnerId Id of the Partner
 */
public data class GetPartnerPlainArgs(
    public val partnerId: String,
) : ConvertibleToJava<com.pulumi.azurenative.managementpartner.inputs.GetPartnerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managementpartner.inputs.GetPartnerPlainArgs =
        com.pulumi.azurenative.managementpartner.inputs.GetPartnerPlainArgs.builder()
            .partnerId(partnerId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartnerPlainArgs].
 */
@PulumiTagMarker
public class GetPartnerPlainArgsBuilder internal constructor() {
    private var partnerId: String? = null

    /**
     * @param value Id of the Partner
     */
    @JvmName("hlgqdarfnfqpwytb")
    public suspend fun partnerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerId = mapped
    }

    internal fun build(): GetPartnerPlainArgs = GetPartnerPlainArgs(
        partnerId = partnerId ?: throw PulumiNullFieldException("partnerId"),
    )
}
