@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin

import com.pulumi.azurenative.maps.kotlin.outputs.MapsAccountPropertiesResponse
import com.pulumi.azurenative.maps.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.maps.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.maps.kotlin.outputs.MapsAccountPropertiesResponse.Companion.toKotlin as mapsAccountPropertiesResponseToKotlin
import com.pulumi.azurenative.maps.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.maps.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.azurenative.maps.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * An Azure resource which represents access to a suite of Maps REST APIs.
 * Azure REST API version: 2021-02-01. Prior API version in Azure Native 1.x: 2018-05-01.
 * Other available API versions: 2018-05-01, 2021-12-01-preview, 2023-06-01, 2023-08-01-preview, 2023-12-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### Create Gen1 Account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.Maps.Account("account", new()
 *     {
 *         AccountName = "myMapsAccount",
 *         Kind = AzureNative.Maps.Kind.Gen1,
 *         Location = "global",
 *         Properties = new AzureNative.Maps.Inputs.MapsAccountPropertiesArgs
 *         {
 *             DisableLocalAuth = false,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Maps.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Maps.Name.S0,
 *         },
 *         Tags =
 *         {
 *             { "test", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maps/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maps.NewAccount(ctx, "account", &maps.AccountArgs{
 * 			AccountName: pulumi.String("myMapsAccount"),
 * 			Kind:        pulumi.String(maps.KindGen1),
 * 			Location:    pulumi.String("global"),
 * 			Properties: &maps.MapsAccountPropertiesArgs{
 * 				DisableLocalAuth: pulumi.Bool(false),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &maps.SkuArgs{
 * 				Name: pulumi.String(maps.NameS0),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"test": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maps.Account;
 * import com.pulumi.azurenative.maps.AccountArgs;
 * import com.pulumi.azurenative.maps.inputs.MapsAccountPropertiesArgs;
 * import com.pulumi.azurenative.maps.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("myMapsAccount")
 *             .kind("Gen1")
 *             .location("global")
 *             .properties(MapsAccountPropertiesArgs.builder()
 *                 .disableLocalAuth(false)
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("S0")
 *                 .build())
 *             .tags(Map.of("test", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Gen2 Account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.Maps.Account("account", new()
 *     {
 *         AccountName = "myMapsAccount",
 *         Kind = AzureNative.Maps.Kind.Gen2,
 *         Location = "global",
 *         Properties = new AzureNative.Maps.Inputs.MapsAccountPropertiesArgs
 *         {
 *             DisableLocalAuth = true,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Maps.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Maps.Name.G2,
 *         },
 *         Tags =
 *         {
 *             { "test", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maps/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maps.NewAccount(ctx, "account", &maps.AccountArgs{
 * 			AccountName: pulumi.String("myMapsAccount"),
 * 			Kind:        pulumi.String(maps.KindGen2),
 * 			Location:    pulumi.String("global"),
 * 			Properties: &maps.MapsAccountPropertiesArgs{
 * 				DisableLocalAuth: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &maps.SkuArgs{
 * 				Name: pulumi.String(maps.NameG2),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"test": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maps.Account;
 * import com.pulumi.azurenative.maps.AccountArgs;
 * import com.pulumi.azurenative.maps.inputs.MapsAccountPropertiesArgs;
 * import com.pulumi.azurenative.maps.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("myMapsAccount")
 *             .kind("Gen2")
 *             .location("global")
 *             .properties(MapsAccountPropertiesArgs.builder()
 *                 .disableLocalAuth(true)
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("G2")
 *                 .build())
 *             .tags(Map.of("test", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maps:Account myMapsAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.azurenative.maps.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * Get or Set Kind property.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The map account properties.
     */
    public val properties: Output<MapsAccountPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                mapsAccountPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The SKU of this account.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.maps.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.azurenative.maps.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit):
    Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
