@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin

import com.pulumi.azurenative.maps.kotlin.outputs.PrivateAtlasPropertiesResponse
import com.pulumi.azurenative.maps.kotlin.outputs.PrivateAtlasPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PrivateAtlase].
 */
@PulumiTagMarker
public class PrivateAtlaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateAtlaseArgs = PrivateAtlaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateAtlaseArgsBuilder.() -> Unit) {
        val builder = PrivateAtlaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateAtlase {
        val builtJavaResource = com.pulumi.azurenative.maps.PrivateAtlase(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrivateAtlase(builtJavaResource)
    }
}

/**
 * An Azure resource which represents which will provision the ability to create private location data.
 * Azure REST API version: 2020-02-01-preview. Prior API version in Azure Native 1.x: 2020-02-01-preview.
 * ## Example Usage
 * ### CreatePrivateAtlas
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateAtlase = new AzureNative.Maps.PrivateAtlase("privateAtlase", new()
 *     {
 *         AccountName = "myMapsAccount",
 *         Location = "unitedstates",
 *         PrivateAtlasName = "myPrivateAtlas",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "test", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maps/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maps.NewPrivateAtlase(ctx, "privateAtlase", &maps.PrivateAtlaseArgs{
 * 			AccountName:       pulumi.String("myMapsAccount"),
 * 			Location:          pulumi.String("unitedstates"),
 * 			PrivateAtlasName:  pulumi.String("myPrivateAtlas"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"test": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maps.PrivateAtlase;
 * import com.pulumi.azurenative.maps.PrivateAtlaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateAtlase = new PrivateAtlase("privateAtlase", PrivateAtlaseArgs.builder()
 *             .accountName("myMapsAccount")
 *             .location("unitedstates")
 *             .privateAtlasName("myPrivateAtlas")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("test", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maps:PrivateAtlase myPrivateAtlas /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}/privateAtlases/{privateAtlasName}
 * ```
 */
public class PrivateAtlase internal constructor(
    override val javaResource: com.pulumi.azurenative.maps.PrivateAtlase,
) : KotlinCustomResource(javaResource, PrivateAtlaseMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Private Atlas resource properties.
     */
    public val properties: Output<PrivateAtlasPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateAtlaseMapper : ResourceMapper<PrivateAtlase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.maps.PrivateAtlase::class == javaResource::class

    override fun map(javaResource: Resource): PrivateAtlase = PrivateAtlase(
        javaResource as
            com.pulumi.azurenative.maps.PrivateAtlase,
    )
}

/**
 * @see [PrivateAtlase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateAtlase].
 */
public suspend fun privateAtlase(
    name: String,
    block: suspend PrivateAtlaseResourceBuilder.() -> Unit,
): PrivateAtlase {
    val builder = PrivateAtlaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateAtlase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateAtlase(name: String): PrivateAtlase {
    val builder = PrivateAtlaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
