@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.inputs

import com.pulumi.azurenative.maps.inputs.CreatorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creator resource properties
 * @property storageUnits The storage units to be allocated. Integer values from 1 to 100, inclusive.
 */
public data class CreatorPropertiesArgs(
    public val storageUnits: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.maps.inputs.CreatorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.maps.inputs.CreatorPropertiesArgs =
        com.pulumi.azurenative.maps.inputs.CreatorPropertiesArgs.builder()
            .storageUnits(storageUnits.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreatorPropertiesArgs].
 */
@PulumiTagMarker
public class CreatorPropertiesArgsBuilder internal constructor() {
    private var storageUnits: Output<Int>? = null

    /**
     * @param value The storage units to be allocated. Integer values from 1 to 100, inclusive.
     */
    @JvmName("ofqlgdixbnwbjyam")
    public suspend fun storageUnits(`value`: Output<Int>) {
        this.storageUnits = value
    }

    /**
     * @param value The storage units to be allocated. Integer values from 1 to 100, inclusive.
     */
    @JvmName("wcjwwiyvyrtytbne")
    public suspend fun storageUnits(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageUnits = mapped
    }

    internal fun build(): CreatorPropertiesArgs = CreatorPropertiesArgs(
        storageUnits = storageUnits ?: throw PulumiNullFieldException("storageUnits"),
    )
}
