@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.inputs

import com.pulumi.azurenative.maps.inputs.GetPrivateAtlasePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Maps Account.
 * @property privateAtlasName The name of the Private Atlas instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateAtlasePlainArgs(
    public val accountName: String,
    public val privateAtlasName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.maps.inputs.GetPrivateAtlasePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.maps.inputs.GetPrivateAtlasePlainArgs =
        com.pulumi.azurenative.maps.inputs.GetPrivateAtlasePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .privateAtlasName(privateAtlasName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateAtlasePlainArgs].
 */
@PulumiTagMarker
public class GetPrivateAtlasePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var privateAtlasName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Maps Account.
     */
    @JvmName("ravwpjmljexqjgtl")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Private Atlas instance.
     */
    @JvmName("bswierqwicwcpqrr")
    public suspend fun privateAtlasName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateAtlasName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iyqlvaqcycnkdmys")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateAtlasePlainArgs = GetPrivateAtlasePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        privateAtlasName = privateAtlasName ?: throw PulumiNullFieldException("privateAtlasName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
