@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.inputs

import com.pulumi.azurenative.maps.inputs.ListAccountSasPlainArgs.builder
import com.pulumi.azurenative.maps.kotlin.enums.SigningKey
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Maps Account.
 * @property expiry The date time offset of when the token validity expires. For example "2017-05-24T10:42:03.1567373Z"
 * @property maxRatePerSecond Required parameter which represents the desired maximum request per second to allowed for the given SAS token. This does not guarantee perfect accuracy in measurements but provides application safe guards of abuse with eventual enforcement.
 * @property principalId The principal Id also known as the object Id of a User Assigned Managed Identity currently assigned to the Map Account. To assign a Managed Identity of the account, use operation Create or Update an assign a User Assigned Identity resource Id.
 * @property regions Optional, allows control of which region locations are permitted access to Azure Maps REST APIs with the SAS token. Example: "eastus", "westus2". Omitting this parameter will allow all region locations to be accessible.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property signingKey The Map account key to use for signing.
 * @property start The date time offset of when the token validity begins. For example "2017-05-24T10:42:03.1567373Z".
 */
public data class ListAccountSasPlainArgs(
    public val accountName: String,
    public val expiry: String,
    public val maxRatePerSecond: Int,
    public val principalId: String,
    public val regions: List<String>? = null,
    public val resourceGroupName: String,
    public val signingKey: Either<String, SigningKey>,
    public val start: String,
) : ConvertibleToJava<com.pulumi.azurenative.maps.inputs.ListAccountSasPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.maps.inputs.ListAccountSasPlainArgs =
        com.pulumi.azurenative.maps.inputs.ListAccountSasPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .expiry(expiry.let({ args0 -> args0 }))
            .maxRatePerSecond(maxRatePerSecond.let({ args0 -> args0 }))
            .principalId(principalId.let({ args0 -> args0 }))
            .regions(regions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .signingKey(
                signingKey.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .start(start.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListAccountSasPlainArgs].
 */
@PulumiTagMarker
public class ListAccountSasPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var expiry: String? = null

    private var maxRatePerSecond: Int? = null

    private var principalId: String? = null

    private var regions: List<String>? = null

    private var resourceGroupName: String? = null

    private var signingKey: Either<String, SigningKey>? = null

    private var start: String? = null

    /**
     * @param value The name of the Maps Account.
     */
    @JvmName("rivuerjfbuixbroi")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The date time offset of when the token validity expires. For example "2017-05-24T10:42:03.1567373Z"
     */
    @JvmName("tjendmknaqklfgqw")
    public suspend fun expiry(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expiry = mapped
    }

    /**
     * @param value Required parameter which represents the desired maximum request per second to allowed for the given SAS token. This does not guarantee perfect accuracy in measurements but provides application safe guards of abuse with eventual enforcement.
     */
    @JvmName("lsimdgwbenawoyfm")
    public suspend fun maxRatePerSecond(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.maxRatePerSecond = mapped
    }

    /**
     * @param value The principal Id also known as the object Id of a User Assigned Managed Identity currently assigned to the Map Account. To assign a Managed Identity of the account, use operation Create or Update an assign a User Assigned Identity resource Id.
     */
    @JvmName("mjlxfcokiumwkasc")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalId = mapped
    }

    /**
     * @param value Optional, allows control of which region locations are permitted access to Azure Maps REST APIs with the SAS token. Example: "eastus", "westus2". Omitting this parameter will allow all region locations to be accessible.
     */
    @JvmName("mbniyxjilvkhdmce")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param values Optional, allows control of which region locations are permitted access to Azure Maps REST APIs with the SAS token. Example: "eastus", "westus2". Omitting this parameter will allow all region locations to be accessible.
     */
    @JvmName("srppmvojuinsgfbw")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pawuutbxquafnjbj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Map account key to use for signing.
     */
    @JvmName("vpsmfytlqblmhvgv")
    public suspend fun signingKey(`value`: Either<String, SigningKey>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.signingKey = mapped
    }

    /**
     * @param value The Map account key to use for signing.
     */
    @JvmName("kupxuvsgwpirifti")
    public fun signingKey(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SigningKey>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.signingKey = mapped
    }

    /**
     * @param value The Map account key to use for signing.
     */
    @JvmName("giogletadblfcnys")
    public fun signingKey(`value`: SigningKey) {
        val toBeMapped = Either.ofRight<String, SigningKey>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.signingKey = mapped
    }

    /**
     * @param value The date time offset of when the token validity begins. For example "2017-05-24T10:42:03.1567373Z".
     */
    @JvmName("ndaqnwaarssqcfgi")
    public suspend fun start(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.start = mapped
    }

    internal fun build(): ListAccountSasPlainArgs = ListAccountSasPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        expiry = expiry ?: throw PulumiNullFieldException("expiry"),
        maxRatePerSecond = maxRatePerSecond ?: throw PulumiNullFieldException("maxRatePerSecond"),
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        regions = regions,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        signingKey = signingKey ?: throw PulumiNullFieldException("signingKey"),
        start = start ?: throw PulumiNullFieldException("start"),
    )
}
