@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A new Sas token which can be used to access the Maps REST APIs and is controlled by the specified Managed identity permissions on Azure (IAM) Role Based Access Control.
 * @property accountSasToken The shared access signature access token.
 */
public data class ListAccountSasResult(
    public val accountSasToken: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maps.outputs.ListAccountSasResult):
            ListAccountSasResult = ListAccountSasResult(
            accountSasToken = javaType.accountSasToken(),
        )
    }
}
