@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin

import com.pulumi.azurenative.marketplace.kotlin.outputs.RuleResponse
import com.pulumi.azurenative.marketplace.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.marketplace.kotlin.outputs.RuleResponse.Companion.toKotlin as ruleResponseToKotlin
import com.pulumi.azurenative.marketplace.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateStoreCollection].
 */
@PulumiTagMarker
public class PrivateStoreCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateStoreCollectionArgs = PrivateStoreCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateStoreCollectionArgsBuilder.() -> Unit) {
        val builder = PrivateStoreCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateStoreCollection {
        val builtJavaResource =
            com.pulumi.azurenative.marketplace.PrivateStoreCollection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateStoreCollection(builtJavaResource)
    }
}

/**
 * The Collection data structure.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * ## Example Usage
 * ### CreatePrivateStoreCollection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateStoreCollection = new AzureNative.Marketplace.PrivateStoreCollection("privateStoreCollection", new()
 *     {
 *         AllSubscriptions = false,
 *         Claim = "",
 *         CollectionId = "d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1",
 *         CollectionName = "Test Collection",
 *         PrivateStoreId = "a0e28e55-90c4-41d8-8e34-bb7ef7775406",
 *         SubscriptionsList = new[]
 *         {
 *             "b340914e-353d-453a-85fb-8f9b65b51f91",
 *             "f2baa04d-5bfc-461b-b6d8-61b403c9ec48",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/marketplace/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := marketplace.NewPrivateStoreCollection(ctx, "privateStoreCollection", &marketplace.PrivateStoreCollectionArgs{
 * 			AllSubscriptions: pulumi.Bool(false),
 * 			Claim:            pulumi.String(""),
 * 			CollectionId:     pulumi.String("d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1"),
 * 			CollectionName:   pulumi.String("Test Collection"),
 * 			PrivateStoreId:   pulumi.String("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
 * 			SubscriptionsList: pulumi.StringArray{
 * 				pulumi.String("b340914e-353d-453a-85fb-8f9b65b51f91"),
 * 				pulumi.String("f2baa04d-5bfc-461b-b6d8-61b403c9ec48"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.marketplace.PrivateStoreCollection;
 * import com.pulumi.azurenative.marketplace.PrivateStoreCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateStoreCollection = new PrivateStoreCollection("privateStoreCollection", PrivateStoreCollectionArgs.builder()
 *             .allSubscriptions(false)
 *             .claim("")
 *             .collectionId("d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1")
 *             .collectionName("Test Collection")
 *             .privateStoreId("a0e28e55-90c4-41d8-8e34-bb7ef7775406")
 *             .subscriptionsList(
 *                 "b340914e-353d-453a-85fb-8f9b65b51f91",
 *                 "f2baa04d-5bfc-461b-b6d8-61b403c9ec48")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:marketplace:PrivateStoreCollection d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1 /providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}
 * ```
 */
public class PrivateStoreCollection internal constructor(
    override val javaResource: com.pulumi.azurenative.marketplace.PrivateStoreCollection,
) : KotlinCustomResource(javaResource, PrivateStoreCollectionMapper) {
    /**
     * Indicating whether all subscriptions are selected (=true) or not (=false).
     */
    public val allSubscriptions: Output<Boolean>?
        get() = javaResource.allSubscriptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets list of collection rules
     */
    public val appliedRules: Output<List<RuleResponse>>
        get() = javaResource.appliedRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ruleResponseToKotlin(args0)
                })
            })
        })

    /**
     * Indicating whether all items are approved for this collection (=true) or not (=false).
     */
    public val approveAllItems: Output<Boolean>
        get() = javaResource.approveAllItems().applyValue({ args0 -> args0 })

    /**
     * Gets the modified date of all items approved.
     */
    public val approveAllItemsModifiedAt: Output<String>
        get() = javaResource.approveAllItemsModifiedAt().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the association with Commercial's Billing Account.
     */
    public val claim: Output<String>?
        get() = javaResource.claim().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets collection Id.
     */
    public val collectionId: Output<String>
        get() = javaResource.collectionId().applyValue({ args0 -> args0 })

    /**
     * Gets or sets collection name.
     */
    public val collectionName: Output<String>?
        get() = javaResource.collectionName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicating whether the collection is enabled or disabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the number of offers associated with the collection.
     */
    public val numberOfOffers: Output<Double>
        get() = javaResource.numberOfOffers().applyValue({ args0 -> args0 })

    /**
     * Gets or sets subscription ids list. Empty list indicates all subscriptions are selected, null indicates no update is done, explicit list indicates the explicit selected subscriptions. On insert, null is considered as bad request
     */
    public val subscriptionsList: Output<List<String>>?
        get() = javaResource.subscriptionsList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateStoreCollectionMapper : ResourceMapper<PrivateStoreCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.marketplace.PrivateStoreCollection::class == javaResource::class

    override fun map(javaResource: Resource): PrivateStoreCollection =
        PrivateStoreCollection(
            javaResource as
                com.pulumi.azurenative.marketplace.PrivateStoreCollection,
        )
}

/**
 * @see [PrivateStoreCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateStoreCollection].
 */
public suspend fun privateStoreCollection(
    name: String,
    block: suspend PrivateStoreCollectionResourceBuilder.() -> Unit,
): PrivateStoreCollection {
    val builder = PrivateStoreCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateStoreCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateStoreCollection(name: String): PrivateStoreCollection {
    val builder = PrivateStoreCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
