@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.AccountFilterArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.FilterTrackSelectionArgs
import com.pulumi.azurenative.media.kotlin.inputs.FilterTrackSelectionArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.FirstQualityArgs
import com.pulumi.azurenative.media.kotlin.inputs.FirstQualityArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.PresentationTimeRangeArgs
import com.pulumi.azurenative.media.kotlin.inputs.PresentationTimeRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Account Filter.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create an Account Filter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accountFilter = new AzureNative.Media.AccountFilter("accountFilter", new()
 *     {
 *         AccountName = "contosomedia",
 *         FilterName = "newAccountFilter",
 *         FirstQuality = new AzureNative.Media.Inputs.FirstQualityArgs
 *         {
 *             Bitrate = 128000,
 *         },
 *         PresentationTimeRange = new AzureNative.Media.Inputs.PresentationTimeRangeArgs
 *         {
 *             EndTimestamp = 170000000,
 *             ForceEndTimestamp = false,
 *             LiveBackoffDuration = 0,
 *             PresentationWindowDuration = 9223372036854774784,
 *             StartTimestamp = 0,
 *             Timescale = 10000000,
 *         },
 *         ResourceGroupName = "contosorg",
 *         Tracks = new[]
 *         {
 *             new AzureNative.Media.Inputs.FilterTrackSelectionArgs
 *             {
 *                 TrackSelections = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = AzureNative.Media.FilterTrackPropertyCompareOperation.Equal,
 *                         Property = AzureNative.Media.FilterTrackPropertyType.Type,
 *                         Value = "Audio",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = AzureNative.Media.FilterTrackPropertyCompareOperation.NotEqual,
 *                         Property = AzureNative.Media.FilterTrackPropertyType.Language,
 *                         Value = "en",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = AzureNative.Media.FilterTrackPropertyCompareOperation.NotEqual,
 *                         Property = AzureNative.Media.FilterTrackPropertyType.FourCC,
 *                         Value = "EC-3",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Media.Inputs.FilterTrackSelectionArgs
 *             {
 *                 TrackSelections = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = AzureNative.Media.FilterTrackPropertyCompareOperation.Equal,
 *                         Property = AzureNative.Media.FilterTrackPropertyType.Type,
 *                         Value = "Video",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = AzureNative.Media.FilterTrackPropertyCompareOperation.Equal,
 *                         Property = AzureNative.Media.FilterTrackPropertyType.Bitrate,
 *                         Value = "3000000-5000000",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewAccountFilter(ctx, "accountFilter", &media.AccountFilterArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			FilterName:  pulumi.String("newAccountFilter"),
 * 			FirstQuality: &media.FirstQualityArgs{
 * 				Bitrate: pulumi.Int(128000),
 * 			},
 * 			PresentationTimeRange: &media.PresentationTimeRangeArgs{
 * 				EndTimestamp:               pulumi.Float64(170000000),
 * 				ForceEndTimestamp:          pulumi.Bool(false),
 * 				LiveBackoffDuration:        pulumi.Float64(0),
 * 				PresentationWindowDuration: pulumi.Float64(9223372036854774784),
 * 				StartTimestamp:             pulumi.Float64(0),
 * 				Timescale:                  pulumi.Float64(10000000),
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			Tracks: media.FilterTrackSelectionArray{
 * 				&media.FilterTrackSelectionArgs{
 * 					TrackSelections: media.FilterTrackPropertyConditionArray{
 * 						&media.FilterTrackPropertyConditionArgs{
 * 							Operation: pulumi.String(media.FilterTrackPropertyCompareOperationEqual),
 * 							Property:  pulumi.String(media.FilterTrackPropertyTypeType),
 * 							Value:     pulumi.String("Audio"),
 * 						},
 * 						&media.FilterTrackPropertyConditionArgs{
 * 							Operation: pulumi.String(media.FilterTrackPropertyCompareOperationNotEqual),
 * 							Property:  pulumi.String(media.FilterTrackPropertyTypeLanguage),
 * 							Value:     pulumi.String("en"),
 * 						},
 * 						&media.FilterTrackPropertyConditionArgs{
 * 							Operation: pulumi.String(media.FilterTrackPropertyCompareOperationNotEqual),
 * 							Property:  pulumi.String(media.FilterTrackPropertyTypeFourCC),
 * 							Value:     pulumi.String("EC-3"),
 * 						},
 * 					},
 * 				},
 * 				&media.FilterTrackSelectionArgs{
 * 					TrackSelections: media.FilterTrackPropertyConditionArray{
 * 						&media.FilterTrackPropertyConditionArgs{
 * 							Operation: pulumi.String(media.FilterTrackPropertyCompareOperationEqual),
 * 							Property:  pulumi.String(media.FilterTrackPropertyTypeType),
 * 							Value:     pulumi.String("Video"),
 * 						},
 * 						&media.FilterTrackPropertyConditionArgs{
 * 							Operation: pulumi.String(media.FilterTrackPropertyCompareOperationEqual),
 * 							Property:  pulumi.String(media.FilterTrackPropertyTypeBitrate),
 * 							Value:     pulumi.String("3000000-5000000"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.AccountFilter;
 * import com.pulumi.azurenative.media.AccountFilterArgs;
 * import com.pulumi.azurenative.media.inputs.FirstQualityArgs;
 * import com.pulumi.azurenative.media.inputs.PresentationTimeRangeArgs;
 * import com.pulumi.azurenative.media.inputs.FilterTrackSelectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accountFilter = new AccountFilter("accountFilter", AccountFilterArgs.builder()
 *             .accountName("contosomedia")
 *             .filterName("newAccountFilter")
 *             .firstQuality(FirstQualityArgs.builder()
 *                 .bitrate(128000)
 *                 .build())
 *             .presentationTimeRange(PresentationTimeRangeArgs.builder()
 *                 .endTimestamp(170000000)
 *                 .forceEndTimestamp(false)
 *                 .liveBackoffDuration(0)
 *                 .presentationWindowDuration(9223372036854774784)
 *                 .startTimestamp(0)
 *                 .timescale(10000000)
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .tracks(
 *                 FilterTrackSelectionArgs.builder()
 *                     .trackSelections(
 *                         FilterTrackPropertyConditionArgs.builder()
 *                             .operation("Equal")
 *                             .property("Type")
 *                             .value("Audio")
 *                             .build(),
 *                         FilterTrackPropertyConditionArgs.builder()
 *                             .operation("NotEqual")
 *                             .property("Language")
 *                             .value("en")
 *                             .build(),
 *                         FilterTrackPropertyConditionArgs.builder()
 *                             .operation("NotEqual")
 *                             .property("FourCC")
 *                             .value("EC-3")
 *                             .build())
 *                     .build(),
 *                 FilterTrackSelectionArgs.builder()
 *                     .trackSelections(
 *                         FilterTrackPropertyConditionArgs.builder()
 *                             .operation("Equal")
 *                             .property("Type")
 *                             .value("Video")
 *                             .build(),
 *                         FilterTrackPropertyConditionArgs.builder()
 *                             .operation("Equal")
 *                             .property("Bitrate")
 *                             .value("3000000-5000000")
 *                             .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:AccountFilter newAccountFilter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/accountFilters/{filterName}
 * ```
 * @property accountName The Media Services account name.
 * @property filterName The Account Filter name
 * @property firstQuality The first quality.
 * @property presentationTimeRange The presentation time range.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property tracks The tracks selection conditions.
 */
public data class AccountFilterArgs(
    public val accountName: Output<String>? = null,
    public val filterName: Output<String>? = null,
    public val firstQuality: Output<FirstQualityArgs>? = null,
    public val presentationTimeRange: Output<PresentationTimeRangeArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tracks: Output<List<FilterTrackSelectionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.AccountFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.media.AccountFilterArgs =
        com.pulumi.azurenative.media.AccountFilterArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .filterName(filterName?.applyValue({ args0 -> args0 }))
            .firstQuality(firstQuality?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presentationTimeRange(
                presentationTimeRange?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tracks(
                tracks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccountFilterArgs].
 */
@PulumiTagMarker
public class AccountFilterArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var filterName: Output<String>? = null

    private var firstQuality: Output<FirstQualityArgs>? = null

    private var presentationTimeRange: Output<PresentationTimeRangeArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tracks: Output<List<FilterTrackSelectionArgs>>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("avtvxvpfhccvcmxu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The Account Filter name
     */
    @JvmName("mnwtlgosmulrurgn")
    public suspend fun filterName(`value`: Output<String>) {
        this.filterName = value
    }

    /**
     * @param value The first quality.
     */
    @JvmName("adhyhuxplhlcricx")
    public suspend fun firstQuality(`value`: Output<FirstQualityArgs>) {
        this.firstQuality = value
    }

    /**
     * @param value The presentation time range.
     */
    @JvmName("afxqthdcncnwdwfn")
    public suspend fun presentationTimeRange(`value`: Output<PresentationTimeRangeArgs>) {
        this.presentationTimeRange = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("onemkireurryoqfa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tracks selection conditions.
     */
    @JvmName("wchfgcakkmwvthmn")
    public suspend fun tracks(`value`: Output<List<FilterTrackSelectionArgs>>) {
        this.tracks = value
    }

    @JvmName("olvbkhlgmecsjgcw")
    public suspend fun tracks(vararg values: Output<FilterTrackSelectionArgs>) {
        this.tracks = Output.all(values.asList())
    }

    /**
     * @param values The tracks selection conditions.
     */
    @JvmName("dxwayobqbgmbfdfe")
    public suspend fun tracks(values: List<Output<FilterTrackSelectionArgs>>) {
        this.tracks = Output.all(values)
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("lhbqlteqhnnypoaa")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The Account Filter name
     */
    @JvmName("vxnfbolrmkcalbpo")
    public suspend fun filterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterName = mapped
    }

    /**
     * @param value The first quality.
     */
    @JvmName("noaldqcirkucbfvj")
    public suspend fun firstQuality(`value`: FirstQualityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstQuality = mapped
    }

    /**
     * @param argument The first quality.
     */
    @JvmName("nanvlirbdndpkxcq")
    public suspend fun firstQuality(argument: suspend FirstQualityArgsBuilder.() -> Unit) {
        val toBeMapped = FirstQualityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firstQuality = mapped
    }

    /**
     * @param value The presentation time range.
     */
    @JvmName("qflerxcurkltktbx")
    public suspend fun presentationTimeRange(`value`: PresentationTimeRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presentationTimeRange = mapped
    }

    /**
     * @param argument The presentation time range.
     */
    @JvmName("jimpedwclurgphxk")
    public suspend
    fun presentationTimeRange(argument: suspend PresentationTimeRangeArgsBuilder.() -> Unit) {
        val toBeMapped = PresentationTimeRangeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presentationTimeRange = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("sfracurfcpaeepsd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tracks selection conditions.
     */
    @JvmName("qapnpietcyhgthyj")
    public suspend fun tracks(`value`: List<FilterTrackSelectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("snlwycbgwwbbiway")
    public suspend fun tracks(argument: List<suspend FilterTrackSelectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilterTrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("vjeuethxyhrmnjtd")
    public suspend fun tracks(vararg argument: suspend FilterTrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FilterTrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("gkolhkiuvtwrlvid")
    public suspend fun tracks(argument: suspend FilterTrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilterTrackSelectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param values The tracks selection conditions.
     */
    @JvmName("fpptnhyqoubjjrhw")
    public suspend fun tracks(vararg values: FilterTrackSelectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    internal fun build(): AccountFilterArgs = AccountFilterArgs(
        accountName = accountName,
        filterName = filterName,
        firstQuality = firstQuality,
        presentationTimeRange = presentationTimeRange,
        resourceGroupName = resourceGroupName,
        tracks = tracks,
    )
}
