@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyOptionResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyOptionResponse.Companion.toKotlin as contentKeyPolicyOptionResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ContentKeyPolicy].
 */
@PulumiTagMarker
public class ContentKeyPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContentKeyPolicyArgs = ContentKeyPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContentKeyPolicyArgsBuilder.() -> Unit) {
        val builder = ContentKeyPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ContentKeyPolicy {
        val builtJavaResource = com.pulumi.azurenative.media.ContentKeyPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContentKeyPolicy(builtJavaResource)
    }
}

/**
 * A Content Key Policy resource.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Creates a Content Key Policy with ClearKey option and Token Restriction
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentKeyPolicy = new AzureNative.Media.ContentKeyPolicy("contentKeyPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         ContentKeyPolicyName = "PolicyWithClearKeyOptionAndSwtTokenRestriction",
 *         Description = "ArmPolicyDescription",
 *         Options = new[]
 *         {
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyClearKeyConfigurationArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration",
 *                 },
 *                 Name = "ClearKeyOption",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyTokenRestrictionArgs
 *                 {
 *                     Audience = "urn:audience",
 *                     Issuer = "urn:issuer",
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 *                     PrimaryVerificationKey = new AzureNative.Media.Inputs.ContentKeyPolicySymmetricTokenKeyArgs
 *                     {
 *                         KeyValue = "AAAAAAAAAAAAAAAAAAAAAA==",
 *                         OdataType = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 *                     },
 *                     RestrictionTokenType = AzureNative.Media.ContentKeyPolicyRestrictionTokenType.Swt,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewContentKeyPolicy(ctx, "contentKeyPolicy", &media.ContentKeyPolicyArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			ContentKeyPolicyName: pulumi.String("PolicyWithClearKeyOptionAndSwtTokenRestriction"),
 * 			Description:          pulumi.String("ArmPolicyDescription"),
 * 			Options: media.ContentKeyPolicyOptionArray{
 * 				&media.ContentKeyPolicyOptionArgs{
 * 					Configuration: media.ContentKeyPolicyClearKeyConfiguration{
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration",
 * 					},
 * 					Name: pulumi.String("ClearKeyOption"),
 * 					Restriction: media.ContentKeyPolicyTokenRestriction{
 * 						Audience:  "urn:audience",
 * 						Issuer:    "urn:issuer",
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 * 						PrimaryVerificationKey: media.ContentKeyPolicySymmetricTokenKey{
 * 							KeyValue:  "AAAAAAAAAAAAAAAAAAAAAA==",
 * 							OdataType: "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 * 						},
 * 						RestrictionTokenType: media.ContentKeyPolicyRestrictionTokenTypeSwt,
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.ContentKeyPolicy;
 * import com.pulumi.azurenative.media.ContentKeyPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.ContentKeyPolicyOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentKeyPolicy = new ContentKeyPolicy("contentKeyPolicy", ContentKeyPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .contentKeyPolicyName("PolicyWithClearKeyOptionAndSwtTokenRestriction")
 *             .description("ArmPolicyDescription")
 *             .options(ContentKeyPolicyOptionArgs.builder()
 *                 .configuration(ContentKeyPolicyClearKeyConfigurationArgs.builder()
 *                     .odataType("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration")
 *                     .build())
 *                 .name("ClearKeyOption")
 *                 .restriction(ContentKeyPolicyOpenRestrictionArgs.builder()
 *                     .audience("urn:audience")
 *                     .issuer("urn:issuer")
 *                     .odataType("#Microsoft.Media.ContentKeyPolicyTokenRestriction")
 *                     .primaryVerificationKey(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .restrictionTokenType("Swt")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Content Key Policy with PlayReady option and Open Restriction
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentKeyPolicy = new AzureNative.Media.ContentKeyPolicy("contentKeyPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         ContentKeyPolicyName = "PolicyWithPlayReadyOptionAndOpenRestriction",
 *         Description = "ArmPolicyDescription",
 *         Options = new[]
 *         {
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyPlayReadyConfigurationArgs
 *                 {
 *                     Licenses = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.ContentKeyPolicyPlayReadyLicenseArgs
 *                         {
 *                             AllowTestDevices = true,
 *                             BeginDate = "2017-10-16T18:22:53.46Z",
 *                             ContentKeyLocation = new AzureNative.Media.Inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs
 *                             {
 *                                 OdataType = "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader",
 *                             },
 *                             ContentType = AzureNative.Media.ContentKeyPolicyPlayReadyContentType.UltraVioletDownload,
 *                             LicenseType = AzureNative.Media.ContentKeyPolicyPlayReadyLicenseType.Persistent,
 *                             PlayRight = new AzureNative.Media.Inputs.ContentKeyPolicyPlayReadyPlayRightArgs
 *                             {
 *                                 AllowPassingVideoContentToUnknownOutput = AzureNative.Media.ContentKeyPolicyPlayReadyUnknownOutputPassingOption.NotAllowed,
 *                                 DigitalVideoOnlyContentRestriction = false,
 *                                 ImageConstraintForAnalogComponentVideoRestriction = true,
 *                                 ImageConstraintForAnalogComputerMonitorRestriction = false,
 *                                 ScmsRestriction = 2,
 *                             },
 *                             SecurityLevel = AzureNative.Media.SecurityLevel.SL150,
 *                         },
 *                     },
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration",
 *                 },
 *                 Name = "ArmPolicyOptionName",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyOpenRestrictionArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyOpenRestriction",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewContentKeyPolicy(ctx, "contentKeyPolicy", &media.ContentKeyPolicyArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			ContentKeyPolicyName: pulumi.String("PolicyWithPlayReadyOptionAndOpenRestriction"),
 * 			Description:          pulumi.String("ArmPolicyDescription"),
 * 			Options: media.ContentKeyPolicyOptionArray{
 * 				&media.ContentKeyPolicyOptionArgs{
 * 					Configuration: media.ContentKeyPolicyPlayReadyConfiguration{
 * 						Licenses: []media.ContentKeyPolicyPlayReadyLicense{
 * 							{
 * 								AllowTestDevices: true,
 * 								BeginDate:        "2017-10-16T18:22:53.46Z",
 * 								ContentKeyLocation: {
 * 									OdataType: "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader",
 * 								},
 * 								ContentType: media.ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload,
 * 								LicenseType: media.ContentKeyPolicyPlayReadyLicenseTypePersistent,
 * 								PlayRight: {
 * 									AllowPassingVideoContentToUnknownOutput:            media.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed,
 * 									DigitalVideoOnlyContentRestriction:                 false,
 * 									ImageConstraintForAnalogComponentVideoRestriction:  true,
 * 									ImageConstraintForAnalogComputerMonitorRestriction: false,
 * 									ScmsRestriction: 2,
 * 								},
 * 								SecurityLevel: media.SecurityLevelSL150,
 * 							},
 * 						},
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration",
 * 					},
 * 					Name: pulumi.String("ArmPolicyOptionName"),
 * 					Restriction: media.ContentKeyPolicyOpenRestriction{
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyOpenRestriction",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.ContentKeyPolicy;
 * import com.pulumi.azurenative.media.ContentKeyPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.ContentKeyPolicyOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentKeyPolicy = new ContentKeyPolicy("contentKeyPolicy", ContentKeyPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .contentKeyPolicyName("PolicyWithPlayReadyOptionAndOpenRestriction")
 *             .description("ArmPolicyDescription")
 *             .options(ContentKeyPolicyOptionArgs.builder()
 *                 .configuration(ContentKeyPolicyClearKeyConfigurationArgs.builder()
 *                     .licenses(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .odataType("#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration")
 *                     .build())
 *                 .name("ArmPolicyOptionName")
 *                 .restriction(ContentKeyPolicyOpenRestrictionArgs.builder()
 *                     .odataType("#Microsoft.Media.ContentKeyPolicyOpenRestriction")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Content Key Policy with Widevine option and Token Restriction
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentKeyPolicy = new AzureNative.Media.ContentKeyPolicy("contentKeyPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         ContentKeyPolicyName = "PolicyWithWidevineOptionAndJwtTokenRestriction",
 *         Description = "ArmPolicyDescription",
 *         Options = new[]
 *         {
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyWidevineConfigurationArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration",
 *                     WidevineTemplate = "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}",
 *                 },
 *                 Name = "widevineoption",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyTokenRestrictionArgs
 *                 {
 *                     AlternateVerificationKeys = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.ContentKeyPolicySymmetricTokenKeyArgs
 *                         {
 *                             KeyValue = "AAAAAAAAAAAAAAAAAAAAAA==",
 *                             OdataType = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 *                         },
 *                     },
 *                     Audience = "urn:audience",
 *                     Issuer = "urn:issuer",
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 *                     PrimaryVerificationKey = new AzureNative.Media.Inputs.ContentKeyPolicyRsaTokenKeyArgs
 *                     {
 *                         Exponent = "AQAB",
 *                         Modulus = "AQAD",
 *                         OdataType = "#Microsoft.Media.ContentKeyPolicyRsaTokenKey",
 *                     },
 *                     RestrictionTokenType = AzureNative.Media.ContentKeyPolicyRestrictionTokenType.Jwt,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewContentKeyPolicy(ctx, "contentKeyPolicy", &media.ContentKeyPolicyArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			ContentKeyPolicyName: pulumi.String("PolicyWithWidevineOptionAndJwtTokenRestriction"),
 * 			Description:          pulumi.String("ArmPolicyDescription"),
 * 			Options: media.ContentKeyPolicyOptionArray{
 * 				&media.ContentKeyPolicyOptionArgs{
 * 					Configuration: media.ContentKeyPolicyWidevineConfiguration{
 * 						OdataType:        "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration",
 * 						WidevineTemplate: "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}",
 * 					},
 * 					Name: pulumi.String("widevineoption"),
 * 					Restriction: media.ContentKeyPolicyTokenRestriction{
 * 						AlternateVerificationKeys: []interface{}{
 * 							media.ContentKeyPolicySymmetricTokenKey{
 * 								KeyValue:  "AAAAAAAAAAAAAAAAAAAAAA==",
 * 								OdataType: "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 * 							},
 * 						},
 * 						Audience:  "urn:audience",
 * 						Issuer:    "urn:issuer",
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 * 						PrimaryVerificationKey: media.ContentKeyPolicyRsaTokenKey{
 * 							Exponent:  "AQAB",
 * 							Modulus:   "AQAD",
 * 							OdataType: "#Microsoft.Media.ContentKeyPolicyRsaTokenKey",
 * 						},
 * 						RestrictionTokenType: media.ContentKeyPolicyRestrictionTokenTypeJwt,
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.ContentKeyPolicy;
 * import com.pulumi.azurenative.media.ContentKeyPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.ContentKeyPolicyOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentKeyPolicy = new ContentKeyPolicy("contentKeyPolicy", ContentKeyPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .contentKeyPolicyName("PolicyWithWidevineOptionAndJwtTokenRestriction")
 *             .description("ArmPolicyDescription")
 *             .options(ContentKeyPolicyOptionArgs.builder()
 *                 .configuration(ContentKeyPolicyClearKeyConfigurationArgs.builder()
 *                     .odataType("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration")
 *                     .widevineTemplate("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}")
 *                     .build())
 *                 .name("widevineoption")
 *                 .restriction(ContentKeyPolicyOpenRestrictionArgs.builder()
 *                     .alternateVerificationKeys(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .audience("urn:audience")
 *                     .issuer("urn:issuer")
 *                     .odataType("#Microsoft.Media.ContentKeyPolicyTokenRestriction")
 *                     .primaryVerificationKey(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .restrictionTokenType("Jwt")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Content Key Policy with multiple options
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentKeyPolicy = new AzureNative.Media.ContentKeyPolicy("contentKeyPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         ContentKeyPolicyName = "PolicyCreatedWithMultipleOptions",
 *         Description = "ArmPolicyDescription",
 *         Options = new[]
 *         {
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyClearKeyConfigurationArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration",
 *                 },
 *                 Name = "ClearKeyOption",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyTokenRestrictionArgs
 *                 {
 *                     Audience = "urn:audience",
 *                     Issuer = "urn:issuer",
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 *                     PrimaryVerificationKey = new AzureNative.Media.Inputs.ContentKeyPolicySymmetricTokenKeyArgs
 *                     {
 *                         KeyValue = "AAAAAAAAAAAAAAAAAAAAAA==",
 *                         OdataType = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 *                     },
 *                     RestrictionTokenType = AzureNative.Media.ContentKeyPolicyRestrictionTokenType.Swt,
 *                 },
 *             },
 *             new AzureNative.Media.Inputs.ContentKeyPolicyOptionArgs
 *             {
 *                 Configuration = new AzureNative.Media.Inputs.ContentKeyPolicyWidevineConfigurationArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration",
 *                     WidevineTemplate = "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}",
 *                 },
 *                 Name = "widevineoption",
 *                 Restriction = new AzureNative.Media.Inputs.ContentKeyPolicyOpenRestrictionArgs
 *                 {
 *                     OdataType = "#Microsoft.Media.ContentKeyPolicyOpenRestriction",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewContentKeyPolicy(ctx, "contentKeyPolicy", &media.ContentKeyPolicyArgs{
 * 			AccountName:          pulumi.String("contosomedia"),
 * 			ContentKeyPolicyName: pulumi.String("PolicyCreatedWithMultipleOptions"),
 * 			Description:          pulumi.String("ArmPolicyDescription"),
 * 			Options: media.ContentKeyPolicyOptionArray{
 * 				&media.ContentKeyPolicyOptionArgs{
 * 					Configuration: media.ContentKeyPolicyClearKeyConfiguration{
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration",
 * 					},
 * 					Name: pulumi.String("ClearKeyOption"),
 * 					Restriction: media.ContentKeyPolicyTokenRestriction{
 * 						Audience:  "urn:audience",
 * 						Issuer:    "urn:issuer",
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyTokenRestriction",
 * 						PrimaryVerificationKey: media.ContentKeyPolicySymmetricTokenKey{
 * 							KeyValue:  "AAAAAAAAAAAAAAAAAAAAAA==",
 * 							OdataType: "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey",
 * 						},
 * 						RestrictionTokenType: media.ContentKeyPolicyRestrictionTokenTypeSwt,
 * 					},
 * 				},
 * 				&media.ContentKeyPolicyOptionArgs{
 * 					Configuration: media.ContentKeyPolicyWidevineConfiguration{
 * 						OdataType:        "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration",
 * 						WidevineTemplate: "{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}",
 * 					},
 * 					Name: pulumi.String("widevineoption"),
 * 					Restriction: media.ContentKeyPolicyOpenRestriction{
 * 						OdataType: "#Microsoft.Media.ContentKeyPolicyOpenRestriction",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.ContentKeyPolicy;
 * import com.pulumi.azurenative.media.ContentKeyPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.ContentKeyPolicyOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentKeyPolicy = new ContentKeyPolicy("contentKeyPolicy", ContentKeyPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .contentKeyPolicyName("PolicyCreatedWithMultipleOptions")
 *             .description("ArmPolicyDescription")
 *             .options(
 *                 ContentKeyPolicyOptionArgs.builder()
 *                     .configuration(ContentKeyPolicyClearKeyConfigurationArgs.builder()
 *                         .odataType("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration")
 *                         .build())
 *                     .name("ClearKeyOption")
 *                     .restriction(ContentKeyPolicyOpenRestrictionArgs.builder()
 *                         .audience("urn:audience")
 *                         .issuer("urn:issuer")
 *                         .odataType("#Microsoft.Media.ContentKeyPolicyTokenRestriction")
 *                         .primaryVerificationKey(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .restrictionTokenType("Swt")
 *                         .build())
 *                     .build(),
 *                 ContentKeyPolicyOptionArgs.builder()
 *                     .configuration(ContentKeyPolicyClearKeyConfigurationArgs.builder()
 *                         .odataType("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration")
 *                         .widevineTemplate("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}")
 *                         .build())
 *                     .name("widevineoption")
 *                     .restriction(ContentKeyPolicyOpenRestrictionArgs.builder()
 *                         .odataType("#Microsoft.Media.ContentKeyPolicyOpenRestriction")
 *                         .build())
 *                     .build())
 *             .resourceGroupName("contosorg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:ContentKeyPolicy PolicyCreatedWithMultipleOptions /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/contentKeyPolicies/{contentKeyPolicyName}
 * ```
 */
public class ContentKeyPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.media.ContentKeyPolicy,
) : KotlinCustomResource(javaResource, ContentKeyPolicyMapper) {
    /**
     * The creation date of the Policy
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * A description for the Policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last modified date of the Policy
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Key Policy options.
     */
    public val options: Output<List<ContentKeyPolicyOptionResponse>>
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    contentKeyPolicyOptionResponseToKotlin(args0)
                })
            })
        })

    /**
     * The legacy Policy ID.
     */
    public val policyId: Output<String>
        get() = javaResource.policyId().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContentKeyPolicyMapper : ResourceMapper<ContentKeyPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.ContentKeyPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ContentKeyPolicy = ContentKeyPolicy(
        javaResource as
            com.pulumi.azurenative.media.ContentKeyPolicy,
    )
}

/**
 * @see [ContentKeyPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContentKeyPolicy].
 */
public suspend fun contentKeyPolicy(
    name: String,
    block: suspend ContentKeyPolicyResourceBuilder.() -> Unit,
): ContentKeyPolicy {
    val builder = ContentKeyPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContentKeyPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contentKeyPolicy(name: String): ContentKeyPolicy {
    val builder = ContentKeyPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
