@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.HlsResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.media.kotlin.outputs.HlsResponse.Companion.toKotlin as hlsResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LiveOutput].
 */
@PulumiTagMarker
public class LiveOutputResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LiveOutputArgs = LiveOutputArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LiveOutputArgsBuilder.() -> Unit) {
        val builder = LiveOutputArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LiveOutput {
        val builtJavaResource = com.pulumi.azurenative.media.LiveOutput(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LiveOutput(builtJavaResource)
    }
}

/**
 * The Live Output.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create a LiveOutput
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var liveOutput = new AzureNative.Media.LiveOutput("liveOutput", new()
 *     {
 *         AccountName = "slitestmedia10",
 *         ArchiveWindowLength = "PT5M",
 *         AssetName = "6f3264f5-a189-48b4-a29a-a40f22575212",
 *         Description = "test live output 1",
 *         Hls = new AzureNative.Media.Inputs.HlsArgs
 *         {
 *             FragmentsPerTsSegment = 5,
 *         },
 *         LiveEventName = "myLiveEvent1",
 *         LiveOutputName = "myLiveOutput1",
 *         ManifestName = "testmanifest",
 *         ResourceGroupName = "mediaresources",
 *         RewindWindowLength = "PT4M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewLiveOutput(ctx, "liveOutput", &media.LiveOutputArgs{
 * 			AccountName:         pulumi.String("slitestmedia10"),
 * 			ArchiveWindowLength: pulumi.String("PT5M"),
 * 			AssetName:           pulumi.String("6f3264f5-a189-48b4-a29a-a40f22575212"),
 * 			Description:         pulumi.String("test live output 1"),
 * 			Hls: &media.HlsArgs{
 * 				FragmentsPerTsSegment: pulumi.Int(5),
 * 			},
 * 			LiveEventName:      pulumi.String("myLiveEvent1"),
 * 			LiveOutputName:     pulumi.String("myLiveOutput1"),
 * 			ManifestName:       pulumi.String("testmanifest"),
 * 			ResourceGroupName:  pulumi.String("mediaresources"),
 * 			RewindWindowLength: pulumi.String("PT4M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.LiveOutput;
 * import com.pulumi.azurenative.media.LiveOutputArgs;
 * import com.pulumi.azurenative.media.inputs.HlsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var liveOutput = new LiveOutput("liveOutput", LiveOutputArgs.builder()
 *             .accountName("slitestmedia10")
 *             .archiveWindowLength("PT5M")
 *             .assetName("6f3264f5-a189-48b4-a29a-a40f22575212")
 *             .description("test live output 1")
 *             .hls(HlsArgs.builder()
 *                 .fragmentsPerTsSegment(5)
 *                 .build())
 *             .liveEventName("myLiveEvent1")
 *             .liveOutputName("myLiveOutput1")
 *             .manifestName("testmanifest")
 *             .resourceGroupName("mediaresources")
 *             .rewindWindowLength("PT4M")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:LiveOutput myLiveOutput1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}
 * ```
 */
public class LiveOutput internal constructor(
    override val javaResource: com.pulumi.azurenative.media.LiveOutput,
) : KotlinCustomResource(javaResource, LiveOutputMapper) {
    /**
     * ISO 8601 time between 1 minute to 25 hours to indicate the maximum content length that can be archived in the asset for this live output. This also sets the maximum content length for the rewind window. For example, use PT1H30M to indicate 1 hour and 30 minutes of archive window.
     */
    public val archiveWindowLength: Output<String>
        get() = javaResource.archiveWindowLength().applyValue({ args0 -> args0 })

    /**
     * The asset that the live output will write to.
     */
    public val assetName: Output<String>
        get() = javaResource.assetName().applyValue({ args0 -> args0 })

    /**
     * The creation time the live output.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * The description of the live output.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * HTTP Live Streaming (HLS) packing setting for the live output.
     */
    public val hls: Output<HlsResponse>?
        get() = javaResource.hls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    hlsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The time the live output was last modified.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The manifest file name. If not provided, the service will generate one automatically.
     */
    public val manifestName: Output<String>?
        get() = javaResource.manifestName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The initial timestamp that the live output will start at, any content before this value will not be archived.
     */
    public val outputSnapTime: Output<Double>?
        get() = javaResource.outputSnapTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the live output.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource state of the live output.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * ISO 8601 time between 1 minute to the duration of archiveWindowLength to control seek-able window length during Live. The service won't use this property once LiveOutput stops. The archived VOD will have full content with original ArchiveWindowLength. For example, use PT1H30M to indicate 1 hour and 30 minutes of rewind window length. Service will use implicit default value 30m only if Live Event enables LL.
     */
    public val rewindWindowLength: Output<String>?
        get() = javaResource.rewindWindowLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LiveOutputMapper : ResourceMapper<LiveOutput> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.LiveOutput::class == javaResource::class

    override fun map(javaResource: Resource): LiveOutput = LiveOutput(
        javaResource as
            com.pulumi.azurenative.media.LiveOutput,
    )
}

/**
 * @see [LiveOutput].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LiveOutput].
 */
public suspend fun liveOutput(name: String, block: suspend LiveOutputResourceBuilder.() -> Unit):
    LiveOutput {
    val builder = LiveOutputResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LiveOutput].
 * @param name The _unique_ name of the resulting resource.
 */
public fun liveOutput(name: String): LiveOutput {
    val builder = LiveOutputResourceBuilder()
    builder.name(name)
    return builder.build()
}
