@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.ArmStreamingEndpointCurrentSkuResponse
import com.pulumi.azurenative.media.kotlin.outputs.CrossSiteAccessPoliciesResponse
import com.pulumi.azurenative.media.kotlin.outputs.StreamingEndpointAccessControlResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.media.kotlin.outputs.ArmStreamingEndpointCurrentSkuResponse.Companion.toKotlin as armStreamingEndpointCurrentSkuResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.CrossSiteAccessPoliciesResponse.Companion.toKotlin as crossSiteAccessPoliciesResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.StreamingEndpointAccessControlResponse.Companion.toKotlin as streamingEndpointAccessControlResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StreamingEndpoint].
 */
@PulumiTagMarker
public class StreamingEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StreamingEndpointArgs = StreamingEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StreamingEndpointArgsBuilder.() -> Unit) {
        val builder = StreamingEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StreamingEndpoint {
        val builtJavaResource = com.pulumi.azurenative.media.StreamingEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StreamingEndpoint(builtJavaResource)
    }
}

/**
 * The streaming endpoint.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2018-06-01-preview.
 * ## Example Usage
 * ### Create a streaming endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingEndpoint = new AzureNative.Media.StreamingEndpoint("streamingEndpoint", new()
 *     {
 *         AccessControl = new AzureNative.Media.Inputs.StreamingEndpointAccessControlArgs
 *         {
 *             Akamai = new AzureNative.Media.Inputs.AkamaiAccessControlArgs
 *             {
 *                 AkamaiSignatureHeaderAuthenticationKeyList = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.AkamaiSignatureHeaderAuthenticationKeyArgs
 *                     {
 *                         Base64Key = "dGVzdGlkMQ==",
 *                         Expiration = "2029-12-31T16:00:00-08:00",
 *                         Identifier = "id1",
 *                     },
 *                     new AzureNative.Media.Inputs.AkamaiSignatureHeaderAuthenticationKeyArgs
 *                     {
 *                         Base64Key = "dGVzdGlkMQ==",
 *                         Expiration = "2030-12-31T16:00:00-08:00",
 *                         Identifier = "id2",
 *                     },
 *                 },
 *             },
 *             Ip = new AzureNative.Media.Inputs.IPAccessControlArgs
 *             {
 *                 Allow = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.IPRangeArgs
 *                     {
 *                         Address = "192.168.1.1",
 *                         Name = "AllowedIp",
 *                     },
 *                 },
 *             },
 *         },
 *         AccountName = "slitestmedia10",
 *         AvailabilitySetName = "availableset",
 *         CdnEnabled = false,
 *         Description = "test event 1",
 *         Location = "West US",
 *         ResourceGroupName = "mediaresources",
 *         ScaleUnits = 1,
 *         StreamingEndpointName = "myStreamingEndpoint1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingEndpoint(ctx, "streamingEndpoint", &media.StreamingEndpointArgs{
 * 			AccessControl: &media.StreamingEndpointAccessControlArgs{
 * 				Akamai: &media.AkamaiAccessControlArgs{
 * 					AkamaiSignatureHeaderAuthenticationKeyList: media.AkamaiSignatureHeaderAuthenticationKeyArray{
 * 						&media.AkamaiSignatureHeaderAuthenticationKeyArgs{
 * 							Base64Key:  pulumi.String("dGVzdGlkMQ=="),
 * 							Expiration: pulumi.String("2029-12-31T16:00:00-08:00"),
 * 							Identifier: pulumi.String("id1"),
 * 						},
 * 						&media.AkamaiSignatureHeaderAuthenticationKeyArgs{
 * 							Base64Key:  pulumi.String("dGVzdGlkMQ=="),
 * 							Expiration: pulumi.String("2030-12-31T16:00:00-08:00"),
 * 							Identifier: pulumi.String("id2"),
 * 						},
 * 					},
 * 				},
 * 				Ip: &media.IPAccessControlArgs{
 * 					Allow: media.IPRangeArray{
 * 						&media.IPRangeArgs{
 * 							Address: pulumi.String("192.168.1.1"),
 * 							Name:    pulumi.String("AllowedIp"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AccountName:           pulumi.String("slitestmedia10"),
 * 			AvailabilitySetName:   pulumi.String("availableset"),
 * 			CdnEnabled:            pulumi.Bool(false),
 * 			Description:           pulumi.String("test event 1"),
 * 			Location:              pulumi.String("West US"),
 * 			ResourceGroupName:     pulumi.String("mediaresources"),
 * 			ScaleUnits:            pulumi.Int(1),
 * 			StreamingEndpointName: pulumi.String("myStreamingEndpoint1"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingEndpoint;
 * import com.pulumi.azurenative.media.StreamingEndpointArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingEndpointAccessControlArgs;
 * import com.pulumi.azurenative.media.inputs.AkamaiAccessControlArgs;
 * import com.pulumi.azurenative.media.inputs.IPAccessControlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingEndpoint = new StreamingEndpoint("streamingEndpoint", StreamingEndpointArgs.builder()
 *             .accessControl(StreamingEndpointAccessControlArgs.builder()
 *                 .akamai(AkamaiAccessControlArgs.builder()
 *                     .akamaiSignatureHeaderAuthenticationKeyList(
 *                         AkamaiSignatureHeaderAuthenticationKeyArgs.builder()
 *                             .base64Key("dGVzdGlkMQ==")
 *                             .expiration("2029-12-31T16:00:00-08:00")
 *                             .identifier("id1")
 *                             .build(),
 *                         AkamaiSignatureHeaderAuthenticationKeyArgs.builder()
 *                             .base64Key("dGVzdGlkMQ==")
 *                             .expiration("2030-12-31T16:00:00-08:00")
 *                             .identifier("id2")
 *                             .build())
 *                     .build())
 *                 .ip(IPAccessControlArgs.builder()
 *                     .allow(IPRangeArgs.builder()
 *                         .address("192.168.1.1")
 *                         .name("AllowedIp")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .accountName("slitestmedia10")
 *             .availabilitySetName("availableset")
 *             .cdnEnabled(false)
 *             .description("test event 1")
 *             .location("West US")
 *             .resourceGroupName("mediaresources")
 *             .scaleUnits(1)
 *             .streamingEndpointName("myStreamingEndpoint1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:StreamingEndpoint myStreamingEndpoint1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}
 * ```
 */
public class StreamingEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.media.StreamingEndpoint,
) : KotlinCustomResource(javaResource, StreamingEndpointMapper) {
    /**
     * The access control definition of the streaming endpoint.
     */
    public val accessControl: Output<StreamingEndpointAccessControlResponse>?
        get() = javaResource.accessControl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> streamingEndpointAccessControlResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * This feature is deprecated, do not set a value for this property.
     */
    public val availabilitySetName: Output<String>?
        get() = javaResource.availabilitySetName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CDN enabled flag.
     */
    public val cdnEnabled: Output<Boolean>?
        get() = javaResource.cdnEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CDN profile name.
     */
    public val cdnProfile: Output<String>?
        get() = javaResource.cdnProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CDN provider name.
     */
    public val cdnProvider: Output<String>?
        get() = javaResource.cdnProvider().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The exact time the streaming endpoint was created.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * The streaming endpoint access policies.
     */
    public val crossSiteAccessPolicies: Output<CrossSiteAccessPoliciesResponse>?
        get() = javaResource.crossSiteAccessPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> crossSiteAccessPoliciesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The custom host names of the streaming endpoint
     */
    public val customHostNames: Output<List<String>>?
        get() = javaResource.customHostNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The streaming endpoint description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The free trial expiration time.
     */
    public val freeTrialEndTime: Output<String>
        get() = javaResource.freeTrialEndTime().applyValue({ args0 -> args0 })

    /**
     * The streaming endpoint host name.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The exact time the streaming endpoint was last modified.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Max cache age
     */
    public val maxCacheAge: Output<Double>?
        get() = javaResource.maxCacheAge().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the streaming endpoint.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource state of the streaming endpoint.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * The number of scale units. Use the Scale operation to adjust this value.
     */
    public val scaleUnits: Output<Int>
        get() = javaResource.scaleUnits().applyValue({ args0 -> args0 })

    /**
     * The streaming endpoint sku.
     */
    public val sku: Output<ArmStreamingEndpointCurrentSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    armStreamingEndpointCurrentSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StreamingEndpointMapper : ResourceMapper<StreamingEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.StreamingEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): StreamingEndpoint = StreamingEndpoint(
        javaResource as
            com.pulumi.azurenative.media.StreamingEndpoint,
    )
}

/**
 * @see [StreamingEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StreamingEndpoint].
 */
public suspend fun streamingEndpoint(
    name: String,
    block: suspend StreamingEndpointResourceBuilder.() -> Unit,
): StreamingEndpoint {
    val builder = StreamingEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StreamingEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun streamingEndpoint(name: String): StreamingEndpoint {
    val builder = StreamingEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
