@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.StreamingPolicyArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.CommonEncryptionCbcsArgs
import com.pulumi.azurenative.media.kotlin.inputs.CommonEncryptionCbcsArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.CommonEncryptionCencArgs
import com.pulumi.azurenative.media.kotlin.inputs.CommonEncryptionCencArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.EnvelopeEncryptionArgs
import com.pulumi.azurenative.media.kotlin.inputs.EnvelopeEncryptionArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.NoEncryptionArgs
import com.pulumi.azurenative.media.kotlin.inputs.NoEncryptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A Streaming Policy resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Creates a Streaming Policy with ClearKey encryption in commonEncryptionCbcs.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCbcs = new AzureNative.Media.Inputs.CommonEncryptionCbcsArgs
 *         {
 *             ClearKeyEncryptionConfiguration = new AzureNative.Media.Inputs.ClearKeyEncryptionConfigurationArgs
 *             {
 *                 CustomKeysAcquisitionUrlTemplate = "https://contoso.com/{AlternativeMediaId}/clearkey/",
 *             },
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cbcsDefaultKey",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = false,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = false,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCbcs: &media.CommonEncryptionCbcsArgs{
 * 				ClearKeyEncryptionConfiguration: &media.ClearKeyEncryptionConfigurationArgs{
 * 					CustomKeysAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AlternativeMediaId}/clearkey/"),
 * 				},
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cbcsDefaultKey"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(false),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(false),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithMultipleOptions"),
 * 			ResourceGroupName:           pulumi.String("contosorg"),
 * 			StreamingPolicyName:         pulumi.String("UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs;
 * import com.pulumi.azurenative.media.inputs.ClearKeyEncryptionConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCbcs(CommonEncryptionCbcsArgs.builder()
 *                 .clearKeyEncryptionConfiguration(ClearKeyEncryptionConfigurationArgs.builder()
 *                     .customKeysAcquisitionUrlTemplate("https://contoso.com/{AlternativeMediaId}/clearkey/")
 *                     .build())
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cbcsDefaultKey")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(false)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(false)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithMultipleOptions")
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with ClearKey encryption in commonEncryptionCenc.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCenc = new AzureNative.Media.Inputs.CommonEncryptionCencArgs
 *         {
 *             ClearKeyEncryptionConfiguration = new AzureNative.Media.Inputs.ClearKeyEncryptionConfigurationArgs
 *             {
 *                 CustomKeysAcquisitionUrlTemplate = "https://contoso.com/{AlternativeMediaId}/clearkey/",
 *             },
 *             ClearTracks = new[]
 *             {
 *                 new AzureNative.Media.Inputs.TrackSelectionArgs
 *                 {
 *                     TrackSelections = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.TrackPropertyConditionArgs
 *                         {
 *                             Operation = AzureNative.Media.TrackPropertyCompareOperation.Equal,
 *                             Property = AzureNative.Media.TrackPropertyType.FourCC,
 *                             Value = "hev1",
 *                         },
 *                     },
 *                 },
 *             },
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cencDefaultKey",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = false,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithPlayReadyOptionAndOpenRestriction",
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCenc: &media.CommonEncryptionCencArgs{
 * 				ClearKeyEncryptionConfiguration: &media.ClearKeyEncryptionConfigurationArgs{
 * 					CustomKeysAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AlternativeMediaId}/clearkey/"),
 * 				},
 * 				ClearTracks: media.TrackSelectionArray{
 * 					&media.TrackSelectionArgs{
 * 						TrackSelections: media.TrackPropertyConditionArray{
 * 							&media.TrackPropertyConditionArgs{
 * 								Operation: pulumi.String(media.TrackPropertyCompareOperationEqual),
 * 								Property:  pulumi.String(media.TrackPropertyTypeFourCC),
 * 								Value:     pulumi.String("hev1"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cencDefaultKey"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(false),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithPlayReadyOptionAndOpenRestriction"),
 * 			ResourceGroupName:           pulumi.String("contosorg"),
 * 			StreamingPolicyName:         pulumi.String("UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs;
 * import com.pulumi.azurenative.media.inputs.ClearKeyEncryptionConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCenc(CommonEncryptionCencArgs.builder()
 *                 .clearKeyEncryptionConfiguration(ClearKeyEncryptionConfigurationArgs.builder()
 *                     .customKeysAcquisitionUrlTemplate("https://contoso.com/{AlternativeMediaId}/clearkey/")
 *                     .build())
 *                 .clearTracks(TrackSelectionArgs.builder()
 *                     .trackSelections(TrackPropertyConditionArgs.builder()
 *                         .operation("Equal")
 *                         .property("FourCC")
 *                         .value("hev1")
 *                         .build())
 *                     .build())
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cencDefaultKey")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(false)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithPlayReadyOptionAndOpenRestriction")
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with clear streaming
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         NoEncryption = new AzureNative.Media.Inputs.NoEncryptionArgs
 *         {
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = true,
 *                 Hls = true,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "clearStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			NoEncryption: &media.NoEncryptionArgs{
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(true),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("contosorg"),
 * 			StreamingPolicyName: pulumi.String("clearStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.NoEncryptionArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .noEncryption(NoEncryptionArgs.builder()
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(true)
 *                     .hls(true)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("clearStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with commonEncryptionCbcs only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCbcs = new AzureNative.Media.Inputs.CommonEncryptionCbcsArgs
 *         {
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cbcsDefaultKey",
 *                 },
 *             },
 *             Drm = new AzureNative.Media.Inputs.CbcsDrmConfigurationArgs
 *             {
 *                 FairPlay = new AzureNative.Media.Inputs.StreamingPolicyFairPlayConfigurationArgs
 *                 {
 *                     AllowPersistentLicense = true,
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = false,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = false,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCbcs: &media.CommonEncryptionCbcsArgs{
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cbcsDefaultKey"),
 * 					},
 * 				},
 * 				Drm: &media.CbcsDrmConfigurationArgs{
 * 					FairPlay: &media.StreamingPolicyFairPlayConfigurationArgs{
 * 						AllowPersistentLicense:              pulumi.Bool(true),
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(false),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(false),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithMultipleOptions"),
 * 			ResourceGroupName:           pulumi.String("contosorg"),
 * 			StreamingPolicyName:         pulumi.String("UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.CbcsDrmConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyFairPlayConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCbcs(CommonEncryptionCbcsArgs.builder()
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cbcsDefaultKey")
 *                         .build())
 *                     .build())
 *                 .drm(CbcsDrmConfigurationArgs.builder()
 *                     .fairPlay(StreamingPolicyFairPlayConfigurationArgs.builder()
 *                         .allowPersistentLicense(true)
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(false)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(false)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithMultipleOptions")
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with commonEncryptionCenc only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCenc = new AzureNative.Media.Inputs.CommonEncryptionCencArgs
 *         {
 *             ClearTracks = new[]
 *             {
 *                 new AzureNative.Media.Inputs.TrackSelectionArgs
 *                 {
 *                     TrackSelections = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.TrackPropertyConditionArgs
 *                         {
 *                             Operation = AzureNative.Media.TrackPropertyCompareOperation.Equal,
 *                             Property = AzureNative.Media.TrackPropertyType.FourCC,
 *                             Value = "hev1",
 *                         },
 *                     },
 *                 },
 *             },
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cencDefaultKey",
 *                 },
 *             },
 *             Drm = new AzureNative.Media.Inputs.CencDrmConfigurationArgs
 *             {
 *                 PlayReady = new AzureNative.Media.Inputs.StreamingPolicyPlayReadyConfigurationArgs
 *                 {
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}",
 *                     PlayReadyCustomAttributes = "PlayReady CustomAttributes",
 *                 },
 *                 Widevine = new AzureNative.Media.Inputs.StreamingPolicyWidevineConfigurationArgs
 *                 {
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = false,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithPlayReadyOptionAndOpenRestriction",
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCenc: &media.CommonEncryptionCencArgs{
 * 				ClearTracks: media.TrackSelectionArray{
 * 					&media.TrackSelectionArgs{
 * 						TrackSelections: media.TrackPropertyConditionArray{
 * 							&media.TrackPropertyConditionArgs{
 * 								Operation: pulumi.String(media.TrackPropertyCompareOperationEqual),
 * 								Property:  pulumi.String(media.TrackPropertyTypeFourCC),
 * 								Value:     pulumi.String("hev1"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cencDefaultKey"),
 * 					},
 * 				},
 * 				Drm: &media.CencDrmConfigurationArgs{
 * 					PlayReady: &media.StreamingPolicyPlayReadyConfigurationArgs{
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}"),
 * 						PlayReadyCustomAttributes:           pulumi.String("PlayReady CustomAttributes"),
 * 					},
 * 					Widevine: &media.StreamingPolicyWidevineConfigurationArgs{
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(false),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithPlayReadyOptionAndOpenRestriction"),
 * 			ResourceGroupName:           pulumi.String("contosorg"),
 * 			StreamingPolicyName:         pulumi.String("UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.CencDrmConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyPlayReadyConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyWidevineConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCenc(CommonEncryptionCencArgs.builder()
 *                 .clearTracks(TrackSelectionArgs.builder()
 *                     .trackSelections(TrackPropertyConditionArgs.builder()
 *                         .operation("Equal")
 *                         .property("FourCC")
 *                         .value("hev1")
 *                         .build())
 *                     .build())
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cencDefaultKey")
 *                         .build())
 *                     .build())
 *                 .drm(CencDrmConfigurationArgs.builder()
 *                     .playReady(StreamingPolicyPlayReadyConfigurationArgs.builder()
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}")
 *                         .playReadyCustomAttributes("PlayReady CustomAttributes")
 *                         .build())
 *                     .widevine(StreamingPolicyWidevineConfigurationArgs.builder()
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(false)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithPlayReadyOptionAndOpenRestriction")
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with envelopeEncryption only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         DefaultContentKeyPolicyName = "PolicyWithClearKeyOptionAndTokenRestriction",
 *         EnvelopeEncryption = new AzureNative.Media.Inputs.EnvelopeEncryptionArgs
 *         {
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "aesDefaultKey",
 *                 },
 *             },
 *             CustomKeyAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}",
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithEnvelopeEncryptionOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName:                 pulumi.String("contosomedia"),
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithClearKeyOptionAndTokenRestriction"),
 * 			EnvelopeEncryption: &media.EnvelopeEncryptionArgs{
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("aesDefaultKey"),
 * 					},
 * 				},
 * 				CustomKeyAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}"),
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("contosorg"),
 * 			StreamingPolicyName: pulumi.String("UserCreatedSecureStreamingPolicyWithEnvelopeEncryptionOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.EnvelopeEncryptionArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .defaultContentKeyPolicyName("PolicyWithClearKeyOptionAndTokenRestriction")
 *             .envelopeEncryption(EnvelopeEncryptionArgs.builder()
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("aesDefaultKey")
 *                         .build())
 *                     .build())
 *                 .customKeyAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}")
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithEnvelopeEncryptionOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with secure streaming
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCbcs = new AzureNative.Media.Inputs.CommonEncryptionCbcsArgs
 *         {
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cbcsDefaultKey",
 *                 },
 *             },
 *             Drm = new AzureNative.Media.Inputs.CbcsDrmConfigurationArgs
 *             {
 *                 FairPlay = new AzureNative.Media.Inputs.StreamingPolicyFairPlayConfigurationArgs
 *                 {
 *                     AllowPersistentLicense = true,
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = false,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = false,
 *             },
 *         },
 *         CommonEncryptionCenc = new AzureNative.Media.Inputs.CommonEncryptionCencArgs
 *         {
 *             ClearTracks = new[]
 *             {
 *                 new AzureNative.Media.Inputs.TrackSelectionArgs
 *                 {
 *                     TrackSelections = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.TrackPropertyConditionArgs
 *                         {
 *                             Operation = AzureNative.Media.TrackPropertyCompareOperation.Equal,
 *                             Property = AzureNative.Media.TrackPropertyType.FourCC,
 *                             Value = "hev1",
 *                         },
 *                     },
 *                 },
 *             },
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cencDefaultKey",
 *                 },
 *             },
 *             Drm = new AzureNative.Media.Inputs.CencDrmConfigurationArgs
 *             {
 *                 PlayReady = new AzureNative.Media.Inputs.StreamingPolicyPlayReadyConfigurationArgs
 *                 {
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}",
 *                     PlayReadyCustomAttributes = "PlayReady CustomAttributes",
 *                 },
 *                 Widevine = new AzureNative.Media.Inputs.StreamingPolicyWidevineConfigurationArgs
 *                 {
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = false,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
 *         EnvelopeEncryption = new AzureNative.Media.Inputs.EnvelopeEncryptionArgs
 *         {
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "aesDefaultKey",
 *                 },
 *             },
 *             CustomKeyAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}",
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCbcs: &media.CommonEncryptionCbcsArgs{
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cbcsDefaultKey"),
 * 					},
 * 				},
 * 				Drm: &media.CbcsDrmConfigurationArgs{
 * 					FairPlay: &media.StreamingPolicyFairPlayConfigurationArgs{
 * 						AllowPersistentLicense:              pulumi.Bool(true),
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(false),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(false),
 * 				},
 * 			},
 * 			CommonEncryptionCenc: &media.CommonEncryptionCencArgs{
 * 				ClearTracks: media.TrackSelectionArray{
 * 					&media.TrackSelectionArgs{
 * 						TrackSelections: media.TrackPropertyConditionArray{
 * 							&media.TrackPropertyConditionArgs{
 * 								Operation: pulumi.String(media.TrackPropertyCompareOperationEqual),
 * 								Property:  pulumi.String(media.TrackPropertyTypeFourCC),
 * 								Value:     pulumi.String("hev1"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cencDefaultKey"),
 * 					},
 * 				},
 * 				Drm: &media.CencDrmConfigurationArgs{
 * 					PlayReady: &media.StreamingPolicyPlayReadyConfigurationArgs{
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}"),
 * 						PlayReadyCustomAttributes:           pulumi.String("PlayReady CustomAttributes"),
 * 					},
 * 					Widevine: &media.StreamingPolicyWidevineConfigurationArgs{
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(false),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithMultipleOptions"),
 * 			EnvelopeEncryption: &media.EnvelopeEncryptionArgs{
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("aesDefaultKey"),
 * 					},
 * 				},
 * 				CustomKeyAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}"),
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("contosorg"),
 * 			StreamingPolicyName: pulumi.String("UserCreatedSecureStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.CbcsDrmConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyFairPlayConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs;
 * import com.pulumi.azurenative.media.inputs.CencDrmConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyPlayReadyConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyWidevineConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.EnvelopeEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCbcs(CommonEncryptionCbcsArgs.builder()
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cbcsDefaultKey")
 *                         .build())
 *                     .build())
 *                 .drm(CbcsDrmConfigurationArgs.builder()
 *                     .fairPlay(StreamingPolicyFairPlayConfigurationArgs.builder()
 *                         .allowPersistentLicense(true)
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(false)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(false)
 *                     .build())
 *                 .build())
 *             .commonEncryptionCenc(CommonEncryptionCencArgs.builder()
 *                 .clearTracks(TrackSelectionArgs.builder()
 *                     .trackSelections(TrackPropertyConditionArgs.builder()
 *                         .operation("Equal")
 *                         .property("FourCC")
 *                         .value("hev1")
 *                         .build())
 *                     .build())
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cencDefaultKey")
 *                         .build())
 *                     .build())
 *                 .drm(CencDrmConfigurationArgs.builder()
 *                     .playReady(StreamingPolicyPlayReadyConfigurationArgs.builder()
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}")
 *                         .playReadyCustomAttributes("PlayReady CustomAttributes")
 *                         .build())
 *                     .widevine(StreamingPolicyWidevineConfigurationArgs.builder()
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(false)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithMultipleOptions")
 *             .envelopeEncryption(EnvelopeEncryptionArgs.builder()
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("aesDefaultKey")
 *                         .build())
 *                     .build())
 *                 .customKeyAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}")
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:StreamingPolicy UserCreatedSecureStreamingPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingPolicies/{streamingPolicyName}
 * ```
 * @property accountName The Media Services account name.
 * @property commonEncryptionCbcs Configuration of CommonEncryptionCbcs
 * @property commonEncryptionCenc Configuration of CommonEncryptionCenc
 * @property defaultContentKeyPolicyName Default ContentKey used by current Streaming Policy
 * @property envelopeEncryption Configuration of EnvelopeEncryption
 * @property noEncryption Configurations of NoEncryption
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property streamingPolicyName The Streaming Policy name.
 */
public data class StreamingPolicyArgs(
    public val accountName: Output<String>? = null,
    public val commonEncryptionCbcs: Output<CommonEncryptionCbcsArgs>? = null,
    public val commonEncryptionCenc: Output<CommonEncryptionCencArgs>? = null,
    public val defaultContentKeyPolicyName: Output<String>? = null,
    public val envelopeEncryption: Output<EnvelopeEncryptionArgs>? = null,
    public val noEncryption: Output<NoEncryptionArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val streamingPolicyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.StreamingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.media.StreamingPolicyArgs =
        com.pulumi.azurenative.media.StreamingPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .commonEncryptionCbcs(
                commonEncryptionCbcs?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .commonEncryptionCenc(
                commonEncryptionCenc?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultContentKeyPolicyName(defaultContentKeyPolicyName?.applyValue({ args0 -> args0 }))
            .envelopeEncryption(
                envelopeEncryption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .noEncryption(noEncryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .streamingPolicyName(streamingPolicyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamingPolicyArgs].
 */
@PulumiTagMarker
public class StreamingPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var commonEncryptionCbcs: Output<CommonEncryptionCbcsArgs>? = null

    private var commonEncryptionCenc: Output<CommonEncryptionCencArgs>? = null

    private var defaultContentKeyPolicyName: Output<String>? = null

    private var envelopeEncryption: Output<EnvelopeEncryptionArgs>? = null

    private var noEncryption: Output<NoEncryptionArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var streamingPolicyName: Output<String>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("halyucfrxnygbitu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Configuration of CommonEncryptionCbcs
     */
    @JvmName("mnqxqclsjmqvrbsm")
    public suspend fun commonEncryptionCbcs(`value`: Output<CommonEncryptionCbcsArgs>) {
        this.commonEncryptionCbcs = value
    }

    /**
     * @param value Configuration of CommonEncryptionCenc
     */
    @JvmName("fhnxelouxikjogqi")
    public suspend fun commonEncryptionCenc(`value`: Output<CommonEncryptionCencArgs>) {
        this.commonEncryptionCenc = value
    }

    /**
     * @param value Default ContentKey used by current Streaming Policy
     */
    @JvmName("aniavdlglwqmdiwv")
    public suspend fun defaultContentKeyPolicyName(`value`: Output<String>) {
        this.defaultContentKeyPolicyName = value
    }

    /**
     * @param value Configuration of EnvelopeEncryption
     */
    @JvmName("ywcvjuoyysmuatdx")
    public suspend fun envelopeEncryption(`value`: Output<EnvelopeEncryptionArgs>) {
        this.envelopeEncryption = value
    }

    /**
     * @param value Configurations of NoEncryption
     */
    @JvmName("qlmjoyexfbewafbj")
    public suspend fun noEncryption(`value`: Output<NoEncryptionArgs>) {
        this.noEncryption = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("ereibubfasqticbm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Streaming Policy name.
     */
    @JvmName("lupjhpiqctjbcgir")
    public suspend fun streamingPolicyName(`value`: Output<String>) {
        this.streamingPolicyName = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("fgdmushuntvvyufr")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Configuration of CommonEncryptionCbcs
     */
    @JvmName("uptxefyyuflntodh")
    public suspend fun commonEncryptionCbcs(`value`: CommonEncryptionCbcsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commonEncryptionCbcs = mapped
    }

    /**
     * @param argument Configuration of CommonEncryptionCbcs
     */
    @JvmName("xhdyrstulmnprjdb")
    public suspend
    fun commonEncryptionCbcs(argument: suspend CommonEncryptionCbcsArgsBuilder.() -> Unit) {
        val toBeMapped = CommonEncryptionCbcsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.commonEncryptionCbcs = mapped
    }

    /**
     * @param value Configuration of CommonEncryptionCenc
     */
    @JvmName("mleqvhdohlextqqr")
    public suspend fun commonEncryptionCenc(`value`: CommonEncryptionCencArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commonEncryptionCenc = mapped
    }

    /**
     * @param argument Configuration of CommonEncryptionCenc
     */
    @JvmName("hamwkirkcyvcxhku")
    public suspend
    fun commonEncryptionCenc(argument: suspend CommonEncryptionCencArgsBuilder.() -> Unit) {
        val toBeMapped = CommonEncryptionCencArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.commonEncryptionCenc = mapped
    }

    /**
     * @param value Default ContentKey used by current Streaming Policy
     */
    @JvmName("rtdnckifntaoasin")
    public suspend fun defaultContentKeyPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultContentKeyPolicyName = mapped
    }

    /**
     * @param value Configuration of EnvelopeEncryption
     */
    @JvmName("vysilbsywdcsektu")
    public suspend fun envelopeEncryption(`value`: EnvelopeEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envelopeEncryption = mapped
    }

    /**
     * @param argument Configuration of EnvelopeEncryption
     */
    @JvmName("yvgpvxgniemejrxo")
    public suspend
    fun envelopeEncryption(argument: suspend EnvelopeEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EnvelopeEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.envelopeEncryption = mapped
    }

    /**
     * @param value Configurations of NoEncryption
     */
    @JvmName("ujbvfckrksjycqoy")
    public suspend fun noEncryption(`value`: NoEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noEncryption = mapped
    }

    /**
     * @param argument Configurations of NoEncryption
     */
    @JvmName("mmpnqeafwrbqsair")
    public suspend fun noEncryption(argument: suspend NoEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = NoEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.noEncryption = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("vuxwhgcyxbeaovsc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Streaming Policy name.
     */
    @JvmName("wqaqwjspjjdiudaj")
    public suspend fun streamingPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingPolicyName = mapped
    }

    internal fun build(): StreamingPolicyArgs = StreamingPolicyArgs(
        accountName = accountName,
        commonEncryptionCbcs = commonEncryptionCbcs,
        commonEncryptionCenc = commonEncryptionCenc,
        defaultContentKeyPolicyName = defaultContentKeyPolicyName,
        envelopeEncryption = envelopeEncryption,
        noEncryption = noEncryption,
        resourceGroupName = resourceGroupName,
        streamingPolicyName = streamingPolicyName,
    )
}
