@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.TrackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Asset Track resource.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-11-01.
 * ## Example Usage
 * ### Creates a Track
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var track = new AzureNative.Media.Track("track", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainer",
 *         ResourceGroupName = "contosorg",
 *         Track = new AzureNative.Media.Inputs.TextTrackArgs
 *         {
 *             DisplayName = "A new track",
 *             FileName = "text3.ttml",
 *             OdataType = "#Microsoft.Media.TextTrack",
 *             PlayerVisibility = AzureNative.Media.Visibility.Visible,
 *         },
 *         TrackName = "text3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewTrack(ctx, "track", &media.TrackArgs{
 * 			AccountName:       pulumi.String("contosomedia"),
 * 			AssetName:         pulumi.String("ClimbingMountRainer"),
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			Track: media.TextTrack{
 * 				DisplayName:      "A new track",
 * 				FileName:         "text3.ttml",
 * 				OdataType:        "#Microsoft.Media.TextTrack",
 * 				PlayerVisibility: media.VisibilityVisible,
 * 			},
 * 			TrackName: pulumi.String("text3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Track;
 * import com.pulumi.azurenative.media.TrackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var track = new Track("track", TrackArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainer")
 *             .resourceGroupName("contosorg")
 *             .track(AudioTrackArgs.builder()
 *                 .displayName("A new track")
 *                 .fileName("text3.ttml")
 *                 .odataType("#Microsoft.Media.TextTrack")
 *                 .playerVisibility("Visible")
 *                 .build())
 *             .trackName("text3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:Track text3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}/tracks/{trackName}
 * ```
 * @property accountName The Media Services account name.
 * @property assetName The Asset name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property track Detailed information about a track in the asset.
 * @property trackName The Asset Track name.
 */
public data class TrackArgs(
    public val accountName: Output<String>? = null,
    public val assetName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val track: Output<Any>? = null,
    public val trackName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.TrackArgs> {
    override fun toJava(): com.pulumi.azurenative.media.TrackArgs =
        com.pulumi.azurenative.media.TrackArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .assetName(assetName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .track(track?.applyValue({ args0 -> args0 }))
            .trackName(trackName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrackArgs].
 */
@PulumiTagMarker
public class TrackArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var assetName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var track: Output<Any>? = null

    private var trackName: Output<String>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("gexrxoifhjmeftra")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("mtwkxbqflkadehlg")
    public suspend fun assetName(`value`: Output<String>) {
        this.assetName = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("qehebyslcwowlbxx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Detailed information about a track in the asset.
     */
    @JvmName("yhbxnijjbgudpxcm")
    public suspend fun track(`value`: Output<Any>) {
        this.track = value
    }

    /**
     * @param value The Asset Track name.
     */
    @JvmName("grgsswkyrthehcni")
    public suspend fun trackName(`value`: Output<String>) {
        this.trackName = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("dkwrckbanpmdvopd")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("gvvrhhlveuknpxyr")
    public suspend fun assetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("xylfgssifyxqfvmv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Detailed information about a track in the asset.
     */
    @JvmName("vcvkwjpnsmxkgbmb")
    public suspend fun track(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.track = mapped
    }

    /**
     * @param value The Asset Track name.
     */
    @JvmName("cvmlsnrourpcuuor")
    public suspend fun trackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackName = mapped
    }

    internal fun build(): TrackArgs = TrackArgs(
        accountName = accountName,
        assetName = assetName,
        resourceGroupName = resourceGroupName,
        track = track,
        trackName = trackName,
    )
}
