@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Blur type
 */
public enum class BlurType(
    public val javaValue: com.pulumi.azurenative.media.enums.BlurType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.BlurType> {
    /**
     * Box: debug filter, bounding box only
     */
    Box(com.pulumi.azurenative.media.enums.BlurType.Box),

    /**
     * Low: box-car blur filter
     */
    Low(com.pulumi.azurenative.media.enums.BlurType.Low),

    /**
     * Med: Gaussian blur filter
     */
    Med(com.pulumi.azurenative.media.enums.BlurType.Med),

    /**
     * High: Confuse blur filter
     */
    High(com.pulumi.azurenative.media.enums.BlurType.High),

    /**
     * Black: Black out filter
     */
    Black(com.pulumi.azurenative.media.enums.BlurType.Black),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.BlurType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.BlurType): BlurType =
            BlurType.values().first { it.javaValue == javaType }
    }
}
