@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
 */
public enum class Complexity(
    public val javaValue: com.pulumi.azurenative.media.enums.Complexity,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.Complexity> {
    /**
     * Configures the encoder to use settings optimized for faster encoding. Quality is sacrificed to decrease encoding time.
     */
    Speed(com.pulumi.azurenative.media.enums.Complexity.Speed),

    /**
     * Configures the encoder to use settings that achieve a balance between speed and quality.
     */
    Balanced(com.pulumi.azurenative.media.enums.Complexity.Balanced),

    /**
     * Configures the encoder to use settings optimized to produce higher quality output at the expense of slower overall encode time.
     */
    Quality(com.pulumi.azurenative.media.enums.Complexity.Quality),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.Complexity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.Complexity): Complexity =
            Complexity.values().first { it.javaValue == javaType }
    }
}
