@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The rental and lease key type.
 */
public enum class ContentKeyPolicyFairPlayRentalAndLeaseKeyType(
    public val javaValue:
    com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType> {
    /**
     * Represents a ContentKeyPolicyFairPlayRentalAndLeaseKeyType that is unavailable in current API version.
     */
    Unknown(com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType.Unknown),

    /**
     * Key duration is not specified.
     */
    Undefined(com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType.Undefined),

    /**
     * Dual expiry for offline rental.
     */
    DualExpiry(com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType.DualExpiry),

    /**
     * Content key can be persisted with an unlimited duration
     */
    PersistentUnlimited(com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType.PersistentUnlimited),

    /**
     * Content key can be persisted and the valid duration is limited by the Rental Duration value
     */
    PersistentLimited(com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType.PersistentLimited),
    ;

    override fun toJava():
        com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType):
            ContentKeyPolicyFairPlayRentalAndLeaseKeyType =
            ContentKeyPolicyFairPlayRentalAndLeaseKeyType.values().first { it.javaValue == javaType }
    }
}
