@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Configures Unknown output handling settings of the license.
 */
public enum class ContentKeyPolicyPlayReadyUnknownOutputPassingOption(
    public val javaValue:
    com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption> {
    /**
     * Represents a ContentKeyPolicyPlayReadyUnknownOutputPassingOption that is unavailable in current API version.
     */
    Unknown(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption.Unknown),

    /**
     * Passing the video portion of protected content to an Unknown Output is not allowed.
     */
    NotAllowed(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption.NotAllowed),

    /**
     * Passing the video portion of protected content to an Unknown Output is allowed.
     */
    Allowed(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption.Allowed),

    /**
     * Passing the video portion of protected content to an Unknown Output is allowed but with constrained resolution.
     */
    AllowedWithVideoConstriction(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption.AllowedWithVideoConstriction),
    ;

    override fun toJava():
        com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption):
            ContentKeyPolicyPlayReadyUnknownOutputPassingOption =
            ContentKeyPolicyPlayReadyUnknownOutputPassingOption.values().first { it.javaValue == javaType }
    }
}
