@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
 */
public enum class EntropyMode(
    public val javaValue: com.pulumi.azurenative.media.enums.EntropyMode,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.EntropyMode> {
    /**
     * Context Adaptive Binary Arithmetic Coder (CABAC) entropy encoding.
     */
    Cabac(com.pulumi.azurenative.media.enums.EntropyMode.Cabac),

    /**
     * Context Adaptive Variable Length Coder (CAVLC) entropy encoding.
     */
    Cavlc(com.pulumi.azurenative.media.enums.EntropyMode.Cavlc),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.EntropyMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.EntropyMode): EntropyMode =
            EntropyMode.values().first { it.javaValue == javaType }
    }
}
