@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The track property type.
 */
public enum class FilterTrackPropertyType(
    public val javaValue: com.pulumi.azurenative.media.enums.FilterTrackPropertyType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.FilterTrackPropertyType> {
    /**
     * The unknown track property type.
     */
    Unknown(com.pulumi.azurenative.media.enums.FilterTrackPropertyType.Unknown),

    /**
     * The type.
     */
    Type(com.pulumi.azurenative.media.enums.FilterTrackPropertyType.Type),

    /**
     * The name.
     */
    Name(com.pulumi.azurenative.media.enums.FilterTrackPropertyType.Name),

    /**
     * The language.
     */
    Language(com.pulumi.azurenative.media.enums.FilterTrackPropertyType.Language),

    /**
     * The fourCC.
     */
    FourCC(com.pulumi.azurenative.media.enums.FilterTrackPropertyType.FourCC),

    /**
     * The bitrate.
     */
    Bitrate(com.pulumi.azurenative.media.enums.FilterTrackPropertyType.Bitrate),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.FilterTrackPropertyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.FilterTrackPropertyType):
            FilterTrackPropertyType =
            FilterTrackPropertyType.values().first { it.javaValue == javaType }
    }
}
