@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Tells the encoder how to choose its encoding settings. The default value is Balanced.
 */
public enum class H264Complexity(
    public val javaValue: com.pulumi.azurenative.media.enums.H264Complexity,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.H264Complexity> {
    /**
     * Tells the encoder to use settings that are optimized for faster encoding. Quality is sacrificed to decrease encoding time.
     */
    Speed(com.pulumi.azurenative.media.enums.H264Complexity.Speed),

    /**
     * Tells the encoder to use settings that achieve a balance between speed and quality.
     */
    Balanced(com.pulumi.azurenative.media.enums.H264Complexity.Balanced),

    /**
     * Tells the encoder to use settings that are optimized to produce higher quality output at the expense of slower overall encode time.
     */
    Quality(com.pulumi.azurenative.media.enums.H264Complexity.Quality),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.H264Complexity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.H264Complexity): H264Complexity =
            H264Complexity.values().first { it.javaValue == javaType }
    }
}
