@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * We currently support Baseline, Main, High, High422, High444. Default is Auto.
 */
public enum class H264VideoProfile(
    public val javaValue: com.pulumi.azurenative.media.enums.H264VideoProfile,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.H264VideoProfile> {
    /**
     * Tells the encoder to automatically determine the appropriate H.264 profile.
     */
    Auto(com.pulumi.azurenative.media.enums.H264VideoProfile.Auto),

    /**
     * Baseline profile
     */
    Baseline(com.pulumi.azurenative.media.enums.H264VideoProfile.Baseline),

    /**
     * Main profile
     */
    Main(com.pulumi.azurenative.media.enums.H264VideoProfile.Main),

    /**
     * High profile.
     */
    High(com.pulumi.azurenative.media.enums.H264VideoProfile.High),

    /**
     * High 4:2:2 profile.
     */
    High422(com.pulumi.azurenative.media.enums.H264VideoProfile.High422),

    /**
     * High 4:4:4 predictive profile.
     */
    High444(com.pulumi.azurenative.media.enums.H264VideoProfile.High444),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.H264VideoProfile = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.H264VideoProfile):
            H264VideoProfile = H264VideoProfile.values().first { it.javaValue == javaType }
    }
}
