@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
 */
public enum class InterleaveOutput(
    public val javaValue: com.pulumi.azurenative.media.enums.InterleaveOutput,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.InterleaveOutput> {
    /**
     * The output is video-only or audio-only.
     */
    NonInterleavedOutput(com.pulumi.azurenative.media.enums.InterleaveOutput.NonInterleavedOutput),

    /**
     * The output includes both audio and video.
     */
    InterleavedOutput(com.pulumi.azurenative.media.enums.InterleaveOutput.InterleavedOutput),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.InterleaveOutput = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.InterleaveOutput):
            InterleaveOutput = InterleaveOutput.values().first { it.javaValue == javaType }
    }
}
