@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The security level.
 */
public enum class SecurityLevel(
    public val javaValue: com.pulumi.azurenative.media.enums.SecurityLevel,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.SecurityLevel> {
    /**
     * Represents a SecurityLevel that is unavailable in current API version.
     */
    Unknown(com.pulumi.azurenative.media.enums.SecurityLevel.Unknown),

    /**
     * For clients under development or test. No protection against unauthorized use.
     */
    SL150(com.pulumi.azurenative.media.enums.SecurityLevel.SL150),

    /**
     * For hardened devices and applications consuming commercial content. Software or hardware protection.
     */
    SL2000(com.pulumi.azurenative.media.enums.SecurityLevel.SL2000),

    /**
     * For hardened devices only. Hardware protection.
     */
    SL3000(com.pulumi.azurenative.media.enums.SecurityLevel.SL3000),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.SecurityLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.SecurityLevel): SecurityLevel =
            SecurityLevel.values().first { it.javaValue == javaType }
    }
}
