@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AkamaiAccessControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Akamai access control
 * @property akamaiSignatureHeaderAuthenticationKeyList authentication key list
 */
public data class AkamaiAccessControlArgs(
    public val akamaiSignatureHeaderAuthenticationKeyList:
    Output<List<AkamaiSignatureHeaderAuthenticationKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.AkamaiAccessControlArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.AkamaiAccessControlArgs =
        com.pulumi.azurenative.media.inputs.AkamaiAccessControlArgs.builder()
            .akamaiSignatureHeaderAuthenticationKeyList(
                akamaiSignatureHeaderAuthenticationKeyList?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AkamaiAccessControlArgs].
 */
@PulumiTagMarker
public class AkamaiAccessControlArgsBuilder internal constructor() {
    private var akamaiSignatureHeaderAuthenticationKeyList:
        Output<List<AkamaiSignatureHeaderAuthenticationKeyArgs>>? = null

    /**
     * @param value authentication key list
     */
    @JvmName("jbqiijspoopndgxe")
    public suspend
    fun akamaiSignatureHeaderAuthenticationKeyList(`value`: Output<List<AkamaiSignatureHeaderAuthenticationKeyArgs>>) {
        this.akamaiSignatureHeaderAuthenticationKeyList = value
    }

    @JvmName("hxuqixylhjscvstj")
    public suspend fun akamaiSignatureHeaderAuthenticationKeyList(
        vararg
        values: Output<AkamaiSignatureHeaderAuthenticationKeyArgs>,
    ) {
        this.akamaiSignatureHeaderAuthenticationKeyList = Output.all(values.asList())
    }

    /**
     * @param values authentication key list
     */
    @JvmName("ckpmebekottltnxr")
    public suspend
    fun akamaiSignatureHeaderAuthenticationKeyList(values: List<Output<AkamaiSignatureHeaderAuthenticationKeyArgs>>) {
        this.akamaiSignatureHeaderAuthenticationKeyList = Output.all(values)
    }

    /**
     * @param value authentication key list
     */
    @JvmName("bgejabsxctadkdrm")
    public suspend
    fun akamaiSignatureHeaderAuthenticationKeyList(`value`: List<AkamaiSignatureHeaderAuthenticationKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.akamaiSignatureHeaderAuthenticationKeyList = mapped
    }

    /**
     * @param argument authentication key list
     */
    @JvmName("dslnegdfedfydekq")
    public suspend
    fun akamaiSignatureHeaderAuthenticationKeyList(argument: List<suspend AkamaiSignatureHeaderAuthenticationKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AkamaiSignatureHeaderAuthenticationKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.akamaiSignatureHeaderAuthenticationKeyList = mapped
    }

    /**
     * @param argument authentication key list
     */
    @JvmName("vpkssxqwemabnhpg")
    public suspend fun akamaiSignatureHeaderAuthenticationKeyList(
        vararg
        argument: suspend AkamaiSignatureHeaderAuthenticationKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AkamaiSignatureHeaderAuthenticationKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.akamaiSignatureHeaderAuthenticationKeyList = mapped
    }

    /**
     * @param argument authentication key list
     */
    @JvmName("xjhrpaclbiowxjiu")
    public suspend
    fun akamaiSignatureHeaderAuthenticationKeyList(argument: suspend AkamaiSignatureHeaderAuthenticationKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AkamaiSignatureHeaderAuthenticationKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.akamaiSignatureHeaderAuthenticationKeyList = mapped
    }

    /**
     * @param values authentication key list
     */
    @JvmName("snrfastmpsfgfcfl")
    public suspend fun akamaiSignatureHeaderAuthenticationKeyList(
        vararg
        values: AkamaiSignatureHeaderAuthenticationKeyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.akamaiSignatureHeaderAuthenticationKeyList = mapped
    }

    internal fun build(): AkamaiAccessControlArgs = AkamaiAccessControlArgs(
        akamaiSignatureHeaderAuthenticationKeyList = akamaiSignatureHeaderAuthenticationKeyList,
    )
}
