@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ArmStreamingEndpointCurrentSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The streaming endpoint current sku.
 * @property capacity The streaming endpoint sku capacity.
 */
public data class ArmStreamingEndpointCurrentSkuArgs(
    public val capacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ArmStreamingEndpointCurrentSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ArmStreamingEndpointCurrentSkuArgs =
        com.pulumi.azurenative.media.inputs.ArmStreamingEndpointCurrentSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArmStreamingEndpointCurrentSkuArgs].
 */
@PulumiTagMarker
public class ArmStreamingEndpointCurrentSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    /**
     * @param value The streaming endpoint sku capacity.
     */
    @JvmName("wteuvkwjklhbacne")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The streaming endpoint sku capacity.
     */
    @JvmName("nkfmuercogbtiibf")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    internal fun build(): ArmStreamingEndpointCurrentSkuArgs = ArmStreamingEndpointCurrentSkuArgs(
        capacity = capacity,
    )
}
