@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AudioArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the common properties for all audio codecs.
 * @property bitrate The bitrate, in bits per second, of the output encoded audio.
 * @property channels The number of channels in the audio.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.Audio'.
 * @property samplingRate The sampling rate to use for encoding in hertz.
 */
public data class AudioArgs(
    public val bitrate: Output<Int>? = null,
    public val channels: Output<Int>? = null,
    public val label: Output<String>? = null,
    public val odataType: Output<String>,
    public val samplingRate: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.AudioArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.AudioArgs =
        com.pulumi.azurenative.media.inputs.AudioArgs.builder()
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .channels(channels?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .samplingRate(samplingRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AudioArgs].
 */
@PulumiTagMarker
public class AudioArgsBuilder internal constructor() {
    private var bitrate: Output<Int>? = null

    private var channels: Output<Int>? = null

    private var label: Output<String>? = null

    private var odataType: Output<String>? = null

    private var samplingRate: Output<Int>? = null

    /**
     * @param value The bitrate, in bits per second, of the output encoded audio.
     */
    @JvmName("qvivrvgrwsamfuxd")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value The number of channels in the audio.
     */
    @JvmName("rkbajxavaodduevp")
    public suspend fun channels(`value`: Output<Int>) {
        this.channels = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("crarmfapaxoeoccn")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.Audio'.
     */
    @JvmName("ysytdcsjmpgwjnyc")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The sampling rate to use for encoding in hertz.
     */
    @JvmName("utgmhgmblqunlfwp")
    public suspend fun samplingRate(`value`: Output<Int>) {
        this.samplingRate = value
    }

    /**
     * @param value The bitrate, in bits per second, of the output encoded audio.
     */
    @JvmName("ipyfmldebmirjmjr")
    public suspend fun bitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value The number of channels in the audio.
     */
    @JvmName("qgfwolsbjshsuoed")
    public suspend fun channels(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channels = mapped
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("pgmrfijxcjydagqn")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.Audio'.
     */
    @JvmName("lohewaodwywysslv")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The sampling rate to use for encoding in hertz.
     */
    @JvmName("askphlfknxqsupks")
    public suspend fun samplingRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingRate = mapped
    }

    internal fun build(): AudioArgs = AudioArgs(
        bitrate = bitrate,
        channels = channels,
        label = label,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        samplingRate = samplingRate,
    )
}
