@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AudioTrackDescriptorArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.ChannelMapping
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A TrackSelection to select audio tracks.
 * @property channelMapping Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
 */
public data class AudioTrackDescriptorArgs(
    public val channelMapping: Output<Either<String, ChannelMapping>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.AudioTrackDescriptorArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.AudioTrackDescriptorArgs =
        com.pulumi.azurenative.media.inputs.AudioTrackDescriptorArgs.builder()
            .channelMapping(
                channelMapping?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AudioTrackDescriptorArgs].
 */
@PulumiTagMarker
public class AudioTrackDescriptorArgsBuilder internal constructor() {
    private var channelMapping: Output<Either<String, ChannelMapping>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("ydjgcxiylrxsudqv")
    public suspend fun channelMapping(`value`: Output<Either<String, ChannelMapping>>) {
        this.channelMapping = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
     */
    @JvmName("oydhddsomtviqavk")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("cryicvpaqshkjgoa")
    public suspend fun channelMapping(`value`: Either<String, ChannelMapping>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("efacfqxtjxfvywej")
    public fun channelMapping(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChannelMapping>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("eqaintvwlesbyjei")
    public fun channelMapping(`value`: ChannelMapping) {
        val toBeMapped = Either.ofRight<String, ChannelMapping>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
     */
    @JvmName("tyeeseqhkyrxdnjp")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): AudioTrackDescriptorArgs = AudioTrackDescriptorArgs(
        channelMapping = channelMapping,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
