@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.BuiltInStandardEncoderPresetArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.EncoderNamedPreset
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a built-in preset for encoding the input video with the Standard Encoder.
 * @property configurations Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
 * @property presetName The built-in preset to be used for encoding videos.
 */
public data class BuiltInStandardEncoderPresetArgs(
    public val configurations: Output<PresetConfigurationsArgs>? = null,
    public val odataType: Output<String>,
    public val presetName: Output<Either<String, EncoderNamedPreset>>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.BuiltInStandardEncoderPresetArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.BuiltInStandardEncoderPresetArgs =
        com.pulumi.azurenative.media.inputs.BuiltInStandardEncoderPresetArgs.builder()
            .configurations(configurations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .presetName(
                presetName.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [BuiltInStandardEncoderPresetArgs].
 */
@PulumiTagMarker
public class BuiltInStandardEncoderPresetArgsBuilder internal constructor() {
    private var configurations: Output<PresetConfigurationsArgs>? = null

    private var odataType: Output<String>? = null

    private var presetName: Output<Either<String, EncoderNamedPreset>>? = null

    /**
     * @param value Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
     */
    @JvmName("unoynicncmmohkox")
    public suspend fun configurations(`value`: Output<PresetConfigurationsArgs>) {
        this.configurations = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
     */
    @JvmName("wbdpthufbxlwbfki")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The built-in preset to be used for encoding videos.
     */
    @JvmName("ifhtnllbckgllmsr")
    public suspend fun presetName(`value`: Output<Either<String, EncoderNamedPreset>>) {
        this.presetName = value
    }

    /**
     * @param value Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
     */
    @JvmName("fyyokftlmuqiwfwd")
    public suspend fun configurations(`value`: PresetConfigurationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
     */
    @JvmName("huermfenfvobseul")
    public suspend fun configurations(argument: suspend PresetConfigurationsArgsBuilder.() -> Unit) {
        val toBeMapped = PresetConfigurationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
     */
    @JvmName("ekmdxpaotitmskha")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The built-in preset to be used for encoding videos.
     */
    @JvmName("avupbohdtmlhaekf")
    public suspend fun presetName(`value`: Either<String, EncoderNamedPreset>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.presetName = mapped
    }

    /**
     * @param value The built-in preset to be used for encoding videos.
     */
    @JvmName("mpavlgmerfcljyqo")
    public fun presetName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncoderNamedPreset>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.presetName = mapped
    }

    /**
     * @param value The built-in preset to be used for encoding videos.
     */
    @JvmName("mbbyobhyfvikvnwk")
    public fun presetName(`value`: EncoderNamedPreset) {
        val toBeMapped = Either.ofRight<String, EncoderNamedPreset>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.presetName = mapped
    }

    internal fun build(): BuiltInStandardEncoderPresetArgs = BuiltInStandardEncoderPresetArgs(
        configurations = configurations,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        presetName = presetName ?: throw PulumiNullFieldException("presetName"),
    )
}
