@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.CbcsDrmConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
 * @property fairPlay FairPlay configurations
 * @property playReady PlayReady configurations
 * @property widevine Widevine configurations
 */
public data class CbcsDrmConfigurationArgs(
    public val fairPlay: Output<StreamingPolicyFairPlayConfigurationArgs>? = null,
    public val playReady: Output<StreamingPolicyPlayReadyConfigurationArgs>? = null,
    public val widevine: Output<StreamingPolicyWidevineConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.CbcsDrmConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.CbcsDrmConfigurationArgs =
        com.pulumi.azurenative.media.inputs.CbcsDrmConfigurationArgs.builder()
            .fairPlay(fairPlay?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .playReady(playReady?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .widevine(widevine?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CbcsDrmConfigurationArgs].
 */
@PulumiTagMarker
public class CbcsDrmConfigurationArgsBuilder internal constructor() {
    private var fairPlay: Output<StreamingPolicyFairPlayConfigurationArgs>? = null

    private var playReady: Output<StreamingPolicyPlayReadyConfigurationArgs>? = null

    private var widevine: Output<StreamingPolicyWidevineConfigurationArgs>? = null

    /**
     * @param value FairPlay configurations
     */
    @JvmName("ltuwdksynuvqopio")
    public suspend fun fairPlay(`value`: Output<StreamingPolicyFairPlayConfigurationArgs>) {
        this.fairPlay = value
    }

    /**
     * @param value PlayReady configurations
     */
    @JvmName("jjnfuvuwjwyxcolc")
    public suspend fun playReady(`value`: Output<StreamingPolicyPlayReadyConfigurationArgs>) {
        this.playReady = value
    }

    /**
     * @param value Widevine configurations
     */
    @JvmName("heakagjlklljicld")
    public suspend fun widevine(`value`: Output<StreamingPolicyWidevineConfigurationArgs>) {
        this.widevine = value
    }

    /**
     * @param value FairPlay configurations
     */
    @JvmName("vqiwfxtkwblwgbfc")
    public suspend fun fairPlay(`value`: StreamingPolicyFairPlayConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fairPlay = mapped
    }

    /**
     * @param argument FairPlay configurations
     */
    @JvmName("qugcomrhrvxvpgmq")
    public suspend
    fun fairPlay(argument: suspend StreamingPolicyFairPlayConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingPolicyFairPlayConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fairPlay = mapped
    }

    /**
     * @param value PlayReady configurations
     */
    @JvmName("ytthgqcwdfsrqixw")
    public suspend fun playReady(`value`: StreamingPolicyPlayReadyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.playReady = mapped
    }

    /**
     * @param argument PlayReady configurations
     */
    @JvmName("milpfruioabrbtle")
    public suspend
    fun playReady(argument: suspend StreamingPolicyPlayReadyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingPolicyPlayReadyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.playReady = mapped
    }

    /**
     * @param value Widevine configurations
     */
    @JvmName("cmbtiuwwovhshpui")
    public suspend fun widevine(`value`: StreamingPolicyWidevineConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.widevine = mapped
    }

    /**
     * @param argument Widevine configurations
     */
    @JvmName("xfjxqkaimyywruou")
    public suspend
    fun widevine(argument: suspend StreamingPolicyWidevineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingPolicyWidevineConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.widevine = mapped
    }

    internal fun build(): CbcsDrmConfigurationArgs = CbcsDrmConfigurationArgs(
        fairPlay = fairPlay,
        playReady = playReady,
        widevine = widevine,
    )
}
