@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class for envelope encryption scheme
 * @property clearKeyEncryptionConfiguration Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
 * @property clearTracks Representing which tracks should not be encrypted
 * @property contentKeys Representing default content key for each encryption scheme and separate content keys for specific tracks
 * @property drm Configuration of DRMs for CommonEncryptionCenc encryption scheme
 * @property enabledProtocols Representing supported protocols
 */
public data class CommonEncryptionCencArgs(
    public val clearKeyEncryptionConfiguration: Output<ClearKeyEncryptionConfigurationArgs>? = null,
    public val clearTracks: Output<List<TrackSelectionArgs>>? = null,
    public val contentKeys: Output<StreamingPolicyContentKeysArgs>? = null,
    public val drm: Output<CencDrmConfigurationArgs>? = null,
    public val enabledProtocols: Output<EnabledProtocolsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs =
        com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs.builder()
            .clearKeyEncryptionConfiguration(
                clearKeyEncryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .clearTracks(
                clearTracks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .contentKeys(contentKeys?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .drm(drm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabledProtocols(
                enabledProtocols?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CommonEncryptionCencArgs].
 */
@PulumiTagMarker
public class CommonEncryptionCencArgsBuilder internal constructor() {
    private var clearKeyEncryptionConfiguration: Output<ClearKeyEncryptionConfigurationArgs>? = null

    private var clearTracks: Output<List<TrackSelectionArgs>>? = null

    private var contentKeys: Output<StreamingPolicyContentKeysArgs>? = null

    private var drm: Output<CencDrmConfigurationArgs>? = null

    private var enabledProtocols: Output<EnabledProtocolsArgs>? = null

    /**
     * @param value Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
     */
    @JvmName("twxofylkxtgsymun")
    public suspend
    fun clearKeyEncryptionConfiguration(`value`: Output<ClearKeyEncryptionConfigurationArgs>) {
        this.clearKeyEncryptionConfiguration = value
    }

    /**
     * @param value Representing which tracks should not be encrypted
     */
    @JvmName("fkvtgwkukekmqjrl")
    public suspend fun clearTracks(`value`: Output<List<TrackSelectionArgs>>) {
        this.clearTracks = value
    }

    @JvmName("estlfixrfogllvxo")
    public suspend fun clearTracks(vararg values: Output<TrackSelectionArgs>) {
        this.clearTracks = Output.all(values.asList())
    }

    /**
     * @param values Representing which tracks should not be encrypted
     */
    @JvmName("ejhxnvilnjudnfcs")
    public suspend fun clearTracks(values: List<Output<TrackSelectionArgs>>) {
        this.clearTracks = Output.all(values)
    }

    /**
     * @param value Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("gmewihobonkdhaiy")
    public suspend fun contentKeys(`value`: Output<StreamingPolicyContentKeysArgs>) {
        this.contentKeys = value
    }

    /**
     * @param value Configuration of DRMs for CommonEncryptionCenc encryption scheme
     */
    @JvmName("kqwkxoavloxhxrcj")
    public suspend fun drm(`value`: Output<CencDrmConfigurationArgs>) {
        this.drm = value
    }

    /**
     * @param value Representing supported protocols
     */
    @JvmName("kueltfcgtbayrxox")
    public suspend fun enabledProtocols(`value`: Output<EnabledProtocolsArgs>) {
        this.enabledProtocols = value
    }

    /**
     * @param value Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
     */
    @JvmName("bumdpudxwadtejmx")
    public suspend
    fun clearKeyEncryptionConfiguration(`value`: ClearKeyEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clearKeyEncryptionConfiguration = mapped
    }

    /**
     * @param argument Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
     */
    @JvmName("uidfsssjmvwovgha")
    public suspend
    fun clearKeyEncryptionConfiguration(argument: suspend ClearKeyEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClearKeyEncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clearKeyEncryptionConfiguration = mapped
    }

    /**
     * @param value Representing which tracks should not be encrypted
     */
    @JvmName("fvirwanwyitegcvp")
    public suspend fun clearTracks(`value`: List<TrackSelectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("elpgoaephehnfatu")
    public suspend fun clearTracks(argument: List<suspend TrackSelectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("canyqfpxwuqxhbev")
    public suspend fun clearTracks(vararg argument: suspend TrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("phkoqfrpmhtoould")
    public suspend fun clearTracks(argument: suspend TrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrackSelectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param values Representing which tracks should not be encrypted
     */
    @JvmName("vfagesddyxkoaeor")
    public suspend fun clearTracks(vararg values: TrackSelectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clearTracks = mapped
    }

    /**
     * @param value Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("qjowesiatgkmbnst")
    public suspend fun contentKeys(`value`: StreamingPolicyContentKeysArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentKeys = mapped
    }

    /**
     * @param argument Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("aqdwclqijcbymhpm")
    public suspend
    fun contentKeys(argument: suspend StreamingPolicyContentKeysArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingPolicyContentKeysArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentKeys = mapped
    }

    /**
     * @param value Configuration of DRMs for CommonEncryptionCenc encryption scheme
     */
    @JvmName("ntgffbmyyjfrktap")
    public suspend fun drm(`value`: CencDrmConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drm = mapped
    }

    /**
     * @param argument Configuration of DRMs for CommonEncryptionCenc encryption scheme
     */
    @JvmName("csqplwasbpnwdolq")
    public suspend fun drm(argument: suspend CencDrmConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CencDrmConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.drm = mapped
    }

    /**
     * @param value Representing supported protocols
     */
    @JvmName("hqiiglibtkmnepdp")
    public suspend fun enabledProtocols(`value`: EnabledProtocolsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledProtocols = mapped
    }

    /**
     * @param argument Representing supported protocols
     */
    @JvmName("vhnnwowavelwgwsg")
    public suspend fun enabledProtocols(argument: suspend EnabledProtocolsArgsBuilder.() -> Unit) {
        val toBeMapped = EnabledProtocolsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enabledProtocols = mapped
    }

    internal fun build(): CommonEncryptionCencArgs = CommonEncryptionCencArgs(
        clearKeyEncryptionConfiguration = clearKeyEncryptionConfiguration,
        clearTracks = clearTracks,
        contentKeys = contentKeys,
        drm = drm,
        enabledProtocols = enabledProtocols,
    )
}
