@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyFairPlayConfigurationArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.ContentKeyPolicyFairPlayRentalAndLeaseKeyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies a configuration for FairPlay licenses.
 * @property ask The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
 * @property fairPlayPfx The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
 * @property fairPlayPfxPassword The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
 * @property offlineRentalConfiguration Offline rental policy
 * @property rentalAndLeaseKeyType The rental and lease key type.
 * @property rentalDuration The rental duration. Must be greater than or equal to 0.
 */
public data class ContentKeyPolicyFairPlayConfigurationArgs(
    public val ask: Output<String>,
    public val fairPlayPfx: Output<String>,
    public val fairPlayPfxPassword: Output<String>,
    public val odataType: Output<String>,
    public val offlineRentalConfiguration:
    Output<ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs>? = null,
    public val rentalAndLeaseKeyType:
    Output<Either<String, ContentKeyPolicyFairPlayRentalAndLeaseKeyType>>,
    public val rentalDuration: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyFairPlayConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyFairPlayConfigurationArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyFairPlayConfigurationArgs.builder()
            .ask(ask.applyValue({ args0 -> args0 }))
            .fairPlayPfx(fairPlayPfx.applyValue({ args0 -> args0 }))
            .fairPlayPfxPassword(fairPlayPfxPassword.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .offlineRentalConfiguration(
                offlineRentalConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rentalAndLeaseKeyType(
                rentalAndLeaseKeyType.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rentalDuration(rentalDuration.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyFairPlayConfigurationArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyFairPlayConfigurationArgsBuilder internal constructor() {
    private var ask: Output<String>? = null

    private var fairPlayPfx: Output<String>? = null

    private var fairPlayPfxPassword: Output<String>? = null

    private var odataType: Output<String>? = null

    private var offlineRentalConfiguration:
        Output<ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs>? = null

    private var rentalAndLeaseKeyType:
        Output<Either<String, ContentKeyPolicyFairPlayRentalAndLeaseKeyType>>? = null

    private var rentalDuration: Output<Double>? = null

    /**
     * @param value The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
     */
    @JvmName("tdcyynmxtcwdosft")
    public suspend fun ask(`value`: Output<String>) {
        this.ask = value
    }

    /**
     * @param value The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
     */
    @JvmName("rgnrxfuysskypbmi")
    public suspend fun fairPlayPfx(`value`: Output<String>) {
        this.fairPlayPfx = value
    }

    /**
     * @param value The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
     */
    @JvmName("uuebtjgpbjentyjy")
    public suspend fun fairPlayPfxPassword(`value`: Output<String>) {
        this.fairPlayPfxPassword = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
     */
    @JvmName("vmuhkglrvralmbii")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Offline rental policy
     */
    @JvmName("tcvjldoepexilsvp")
    public suspend
    fun offlineRentalConfiguration(`value`: Output<ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs>) {
        this.offlineRentalConfiguration = value
    }

    /**
     * @param value The rental and lease key type.
     */
    @JvmName("trolctkboovtxpqk")
    public suspend
    fun rentalAndLeaseKeyType(`value`: Output<Either<String, ContentKeyPolicyFairPlayRentalAndLeaseKeyType>>) {
        this.rentalAndLeaseKeyType = value
    }

    /**
     * @param value The rental duration. Must be greater than or equal to 0.
     */
    @JvmName("wyempwyxfrtsilaq")
    public suspend fun rentalDuration(`value`: Output<Double>) {
        this.rentalDuration = value
    }

    /**
     * @param value The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
     */
    @JvmName("fodukfwboolfdhpj")
    public suspend fun ask(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ask = mapped
    }

    /**
     * @param value The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
     */
    @JvmName("kgfmffvhdtseuaxc")
    public suspend fun fairPlayPfx(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fairPlayPfx = mapped
    }

    /**
     * @param value The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
     */
    @JvmName("rrudfofwcclucieu")
    public suspend fun fairPlayPfxPassword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fairPlayPfxPassword = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
     */
    @JvmName("yrpvmpgslnlmjcqd")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Offline rental policy
     */
    @JvmName("lhwetitqrmaqkdyu")
    public suspend
    fun offlineRentalConfiguration(`value`: ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offlineRentalConfiguration = mapped
    }

    /**
     * @param argument Offline rental policy
     */
    @JvmName("vostdsfosxmlkhmp")
    public suspend
    fun offlineRentalConfiguration(argument: suspend ContentKeyPolicyFairPlayOfflineRentalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContentKeyPolicyFairPlayOfflineRentalConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.offlineRentalConfiguration = mapped
    }

    /**
     * @param value The rental and lease key type.
     */
    @JvmName("xnnnhinohlfpfeci")
    public suspend
    fun rentalAndLeaseKeyType(`value`: Either<String, ContentKeyPolicyFairPlayRentalAndLeaseKeyType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rentalAndLeaseKeyType = mapped
    }

    /**
     * @param value The rental and lease key type.
     */
    @JvmName("pqbjbglknxusgows")
    public fun rentalAndLeaseKeyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentKeyPolicyFairPlayRentalAndLeaseKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rentalAndLeaseKeyType = mapped
    }

    /**
     * @param value The rental and lease key type.
     */
    @JvmName("qbwyboicbaqoyjvn")
    public fun rentalAndLeaseKeyType(`value`: ContentKeyPolicyFairPlayRentalAndLeaseKeyType) {
        val toBeMapped = Either.ofRight<String, ContentKeyPolicyFairPlayRentalAndLeaseKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rentalAndLeaseKeyType = mapped
    }

    /**
     * @param value The rental duration. Must be greater than or equal to 0.
     */
    @JvmName("fqbvqtlfgbnjhrkr")
    public suspend fun rentalDuration(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rentalDuration = mapped
    }

    internal fun build(): ContentKeyPolicyFairPlayConfigurationArgs =
        ContentKeyPolicyFairPlayConfigurationArgs(
            ask = ask ?: throw PulumiNullFieldException("ask"),
            fairPlayPfx = fairPlayPfx ?: throw PulumiNullFieldException("fairPlayPfx"),
            fairPlayPfxPassword = fairPlayPfxPassword ?: throw PulumiNullFieldException("fairPlayPfxPassword"),
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
            offlineRentalConfiguration = offlineRentalConfiguration,
            rentalAndLeaseKeyType = rentalAndLeaseKeyType ?: throw
                PulumiNullFieldException("rentalAndLeaseKeyType"),
            rentalDuration = rentalDuration ?: throw PulumiNullFieldException("rentalDuration"),
        )
}
