@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies that the content key ID is specified in the PlayReady configuration.
 * @property keyId The content key ID.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
 */
public data class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs(
    public val keyId: Output<String>,
    public val odataType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs.builder()
            .keyId(keyId.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgsBuilder internal
constructor() {
    private var keyId: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The content key ID.
     */
    @JvmName("nsaytpnyxgxxgmtw")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
     */
    @JvmName("xtrqrhffwuwkcwty")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The content key ID.
     */
    @JvmName("krnyjxwlcavjthue")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
     */
    @JvmName("jfdlajivqfqcbfmw")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs =
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs(
            keyId = keyId ?: throw PulumiNullFieldException("keyId"),
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        )
}
