@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyLicenseArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.ContentKeyPolicyPlayReadyContentType
import com.pulumi.azurenative.media.kotlin.enums.ContentKeyPolicyPlayReadyLicenseType
import com.pulumi.azurenative.media.kotlin.enums.SecurityLevel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The PlayReady license
 * @property allowTestDevices A flag indicating whether test devices can use the license.
 * @property beginDate The begin date of license
 * @property contentKeyLocation The content key location.
 * @property contentType The PlayReady content type.
 * @property expirationDate The expiration date of license.
 * @property gracePeriod The grace period of license.
 * @property licenseType The license type.
 * @property playRight The license PlayRight
 * @property relativeBeginDate The relative begin date of license.
 * @property relativeExpirationDate The relative expiration date of license.
 * @property securityLevel The security level.
 */
public data class ContentKeyPolicyPlayReadyLicenseArgs(
    public val allowTestDevices: Output<Boolean>,
    public val beginDate: Output<String>? = null,
    public val contentKeyLocation:
    Output<Either<ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs, ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs>>,
    public val contentType: Output<Either<String, ContentKeyPolicyPlayReadyContentType>>,
    public val expirationDate: Output<String>? = null,
    public val gracePeriod: Output<String>? = null,
    public val licenseType: Output<Either<String, ContentKeyPolicyPlayReadyLicenseType>>,
    public val playRight: Output<ContentKeyPolicyPlayReadyPlayRightArgs>? = null,
    public val relativeBeginDate: Output<String>? = null,
    public val relativeExpirationDate: Output<String>? = null,
    public val securityLevel: Output<Either<String, SecurityLevel>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyLicenseArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyLicenseArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyLicenseArgs.builder()
            .allowTestDevices(allowTestDevices.applyValue({ args0 -> args0 }))
            .beginDate(beginDate?.applyValue({ args0 -> args0 }))
            .contentKeyLocation(
                contentKeyLocation.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .contentType(
                contentType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .gracePeriod(gracePeriod?.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .playRight(playRight?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .relativeBeginDate(relativeBeginDate?.applyValue({ args0 -> args0 }))
            .relativeExpirationDate(relativeExpirationDate?.applyValue({ args0 -> args0 }))
            .securityLevel(
                securityLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContentKeyPolicyPlayReadyLicenseArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyPlayReadyLicenseArgsBuilder internal constructor() {
    private var allowTestDevices: Output<Boolean>? = null

    private var beginDate: Output<String>? = null

    private var contentKeyLocation:
        Output<Either<ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs, ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs>>? =
        null

    private var contentType: Output<Either<String, ContentKeyPolicyPlayReadyContentType>>? = null

    private var expirationDate: Output<String>? = null

    private var gracePeriod: Output<String>? = null

    private var licenseType: Output<Either<String, ContentKeyPolicyPlayReadyLicenseType>>? = null

    private var playRight: Output<ContentKeyPolicyPlayReadyPlayRightArgs>? = null

    private var relativeBeginDate: Output<String>? = null

    private var relativeExpirationDate: Output<String>? = null

    private var securityLevel: Output<Either<String, SecurityLevel>>? = null

    /**
     * @param value A flag indicating whether test devices can use the license.
     */
    @JvmName("uxufkknwcgyhhyvf")
    public suspend fun allowTestDevices(`value`: Output<Boolean>) {
        this.allowTestDevices = value
    }

    /**
     * @param value The begin date of license
     */
    @JvmName("ktqtrmgrlemgpqpb")
    public suspend fun beginDate(`value`: Output<String>) {
        this.beginDate = value
    }

    /**
     * @param value The content key location.
     */
    @JvmName("kyqncevarvydkavr")
    public suspend
    fun contentKeyLocation(`value`: Output<Either<ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs, ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs>>) {
        this.contentKeyLocation = value
    }

    /**
     * @param value The PlayReady content type.
     */
    @JvmName("bdehcvkbivdhhkgy")
    public suspend
    fun contentType(`value`: Output<Either<String, ContentKeyPolicyPlayReadyContentType>>) {
        this.contentType = value
    }

    /**
     * @param value The expiration date of license.
     */
    @JvmName("rowjwwstoihmaemv")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value The grace period of license.
     */
    @JvmName("tuqunwchyjknvtrv")
    public suspend fun gracePeriod(`value`: Output<String>) {
        this.gracePeriod = value
    }

    /**
     * @param value The license type.
     */
    @JvmName("ijmbhkfjotvkceco")
    public suspend
    fun licenseType(`value`: Output<Either<String, ContentKeyPolicyPlayReadyLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value The license PlayRight
     */
    @JvmName("lodrbimqhjgnogfc")
    public suspend fun playRight(`value`: Output<ContentKeyPolicyPlayReadyPlayRightArgs>) {
        this.playRight = value
    }

    /**
     * @param value The relative begin date of license.
     */
    @JvmName("lxdjrpcfmpdxorpe")
    public suspend fun relativeBeginDate(`value`: Output<String>) {
        this.relativeBeginDate = value
    }

    /**
     * @param value The relative expiration date of license.
     */
    @JvmName("tjvlqaugmqhiamfx")
    public suspend fun relativeExpirationDate(`value`: Output<String>) {
        this.relativeExpirationDate = value
    }

    /**
     * @param value The security level.
     */
    @JvmName("kkcfdhbgqbayoqpw")
    public suspend fun securityLevel(`value`: Output<Either<String, SecurityLevel>>) {
        this.securityLevel = value
    }

    /**
     * @param value A flag indicating whether test devices can use the license.
     */
    @JvmName("blcgicawegcyuoja")
    public suspend fun allowTestDevices(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowTestDevices = mapped
    }

    /**
     * @param value The begin date of license
     */
    @JvmName("fdeywxkwinnyjsop")
    public suspend fun beginDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beginDate = mapped
    }

    /**
     * @param value The content key location.
     */
    @JvmName("nwgckqwxotxntsao")
    public suspend
    fun contentKeyLocation(`value`: Either<ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs, ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentKeyLocation = mapped
    }

    /**
     * @param value The content key location.
     */
    @JvmName("wugmbyykjehggwkd")
    public
    fun contentKeyLocation(`value`: ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs) {
        val toBeMapped = Either.ofLeft<ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs,
            ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentKeyLocation = mapped
    }

    /**
     * @param value The content key location.
     */
    @JvmName("looavhujbxtkgorn")
    public
    fun contentKeyLocation(`value`: ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs) {
        val toBeMapped = Either.ofRight<ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs,
            ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentKeyLocation = mapped
    }

    /**
     * @param value The PlayReady content type.
     */
    @JvmName("uhlhuullhdfomcys")
    public suspend fun contentType(`value`: Either<String, ContentKeyPolicyPlayReadyContentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The PlayReady content type.
     */
    @JvmName("hppnjekalrogbgqo")
    public fun contentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentKeyPolicyPlayReadyContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The PlayReady content type.
     */
    @JvmName("wwjvdywekiucgcfc")
    public fun contentType(`value`: ContentKeyPolicyPlayReadyContentType) {
        val toBeMapped = Either.ofRight<String, ContentKeyPolicyPlayReadyContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The expiration date of license.
     */
    @JvmName("punaunvubxbktvym")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value The grace period of license.
     */
    @JvmName("eekgerfkgmvmajmq")
    public suspend fun gracePeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gracePeriod = mapped
    }

    /**
     * @param value The license type.
     */
    @JvmName("bfvtujxxvrilgwdc")
    public suspend fun licenseType(`value`: Either<String, ContentKeyPolicyPlayReadyLicenseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type.
     */
    @JvmName("rkoiaarofessyjcx")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentKeyPolicyPlayReadyLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type.
     */
    @JvmName("njxhjtxjtfthtlan")
    public fun licenseType(`value`: ContentKeyPolicyPlayReadyLicenseType) {
        val toBeMapped = Either.ofRight<String, ContentKeyPolicyPlayReadyLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license PlayRight
     */
    @JvmName("mrfajadcamtbyrxy")
    public suspend fun playRight(`value`: ContentKeyPolicyPlayReadyPlayRightArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.playRight = mapped
    }

    /**
     * @param argument The license PlayRight
     */
    @JvmName("qmrmmnlkgabuikiq")
    public suspend
    fun playRight(argument: suspend ContentKeyPolicyPlayReadyPlayRightArgsBuilder.() -> Unit) {
        val toBeMapped = ContentKeyPolicyPlayReadyPlayRightArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.playRight = mapped
    }

    /**
     * @param value The relative begin date of license.
     */
    @JvmName("ncnebqpwwesatlne")
    public suspend fun relativeBeginDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativeBeginDate = mapped
    }

    /**
     * @param value The relative expiration date of license.
     */
    @JvmName("jvgoyekhhlblasen")
    public suspend fun relativeExpirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativeExpirationDate = mapped
    }

    /**
     * @param value The security level.
     */
    @JvmName("wlfqffiotnbntodm")
    public suspend fun securityLevel(`value`: Either<String, SecurityLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityLevel = mapped
    }

    /**
     * @param value The security level.
     */
    @JvmName("xxxemaxkwtnoojlv")
    public fun securityLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityLevel = mapped
    }

    /**
     * @param value The security level.
     */
    @JvmName("ofjsrimskjviworn")
    public fun securityLevel(`value`: SecurityLevel) {
        val toBeMapped = Either.ofRight<String, SecurityLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityLevel = mapped
    }

    internal fun build(): ContentKeyPolicyPlayReadyLicenseArgs = ContentKeyPolicyPlayReadyLicenseArgs(
        allowTestDevices = allowTestDevices ?: throw PulumiNullFieldException("allowTestDevices"),
        beginDate = beginDate,
        contentKeyLocation = contentKeyLocation ?: throw PulumiNullFieldException("contentKeyLocation"),
        contentType = contentType ?: throw PulumiNullFieldException("contentType"),
        expirationDate = expirationDate,
        gracePeriod = gracePeriod,
        licenseType = licenseType ?: throw PulumiNullFieldException("licenseType"),
        playRight = playRight,
        relativeBeginDate = relativeBeginDate,
        relativeExpirationDate = relativeExpirationDate,
        securityLevel = securityLevel,
    )
}
