@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyPlayRightArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.ContentKeyPolicyPlayReadyUnknownOutputPassingOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configures the Play Right in the PlayReady license.
 * @property agcAndColorStripeRestriction Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
 * @property allowPassingVideoContentToUnknownOutput Configures Unknown output handling settings of the license.
 * @property analogVideoOpl Specifies the output protection level for compressed digital audio.
 * @property compressedDigitalAudioOpl Specifies the output protection level for compressed digital audio.
 * @property compressedDigitalVideoOpl Specifies the output protection level for compressed digital video.
 * @property digitalVideoOnlyContentRestriction Enables the Image Constraint For Analog Component Video Restriction in the license.
 * @property explicitAnalogTelevisionOutputRestriction Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
 * @property firstPlayExpiration The amount of time that the license is valid after the license is first used to play content.
 * @property imageConstraintForAnalogComponentVideoRestriction Enables the Image Constraint For Analog Component Video Restriction in the license.
 * @property imageConstraintForAnalogComputerMonitorRestriction Enables the Image Constraint For Analog Component Video Restriction in the license.
 * @property scmsRestriction Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
 * @property uncompressedDigitalAudioOpl Specifies the output protection level for uncompressed digital audio.
 * @property uncompressedDigitalVideoOpl Specifies the output protection level for uncompressed digital video.
 */
public data class ContentKeyPolicyPlayReadyPlayRightArgs(
    public val agcAndColorStripeRestriction: Output<Int>? = null,
    public val allowPassingVideoContentToUnknownOutput:
    Output<Either<String, ContentKeyPolicyPlayReadyUnknownOutputPassingOption>>,
    public val analogVideoOpl: Output<Int>? = null,
    public val compressedDigitalAudioOpl: Output<Int>? = null,
    public val compressedDigitalVideoOpl: Output<Int>? = null,
    public val digitalVideoOnlyContentRestriction: Output<Boolean>,
    public val explicitAnalogTelevisionOutputRestriction:
    Output<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs>? = null,
    public val firstPlayExpiration: Output<String>? = null,
    public val imageConstraintForAnalogComponentVideoRestriction: Output<Boolean>,
    public val imageConstraintForAnalogComputerMonitorRestriction: Output<Boolean>,
    public val scmsRestriction: Output<Int>? = null,
    public val uncompressedDigitalAudioOpl: Output<Int>? = null,
    public val uncompressedDigitalVideoOpl: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyPlayRightArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyPlayRightArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyPlayReadyPlayRightArgs.builder()
            .agcAndColorStripeRestriction(agcAndColorStripeRestriction?.applyValue({ args0 -> args0 }))
            .allowPassingVideoContentToUnknownOutput(
                allowPassingVideoContentToUnknownOutput.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .analogVideoOpl(analogVideoOpl?.applyValue({ args0 -> args0 }))
            .compressedDigitalAudioOpl(compressedDigitalAudioOpl?.applyValue({ args0 -> args0 }))
            .compressedDigitalVideoOpl(compressedDigitalVideoOpl?.applyValue({ args0 -> args0 }))
            .digitalVideoOnlyContentRestriction(
                digitalVideoOnlyContentRestriction.applyValue({ args0 ->
                    args0
                }),
            )
            .explicitAnalogTelevisionOutputRestriction(
                explicitAnalogTelevisionOutputRestriction?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .firstPlayExpiration(firstPlayExpiration?.applyValue({ args0 -> args0 }))
            .imageConstraintForAnalogComponentVideoRestriction(
                imageConstraintForAnalogComponentVideoRestriction.applyValue({ args0 ->
                    args0
                }),
            )
            .imageConstraintForAnalogComputerMonitorRestriction(
                imageConstraintForAnalogComputerMonitorRestriction.applyValue({ args0 ->
                    args0
                }),
            )
            .scmsRestriction(scmsRestriction?.applyValue({ args0 -> args0 }))
            .uncompressedDigitalAudioOpl(uncompressedDigitalAudioOpl?.applyValue({ args0 -> args0 }))
            .uncompressedDigitalVideoOpl(uncompressedDigitalVideoOpl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyPlayReadyPlayRightArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyPlayReadyPlayRightArgsBuilder internal constructor() {
    private var agcAndColorStripeRestriction: Output<Int>? = null

    private var allowPassingVideoContentToUnknownOutput:
        Output<Either<String, ContentKeyPolicyPlayReadyUnknownOutputPassingOption>>? = null

    private var analogVideoOpl: Output<Int>? = null

    private var compressedDigitalAudioOpl: Output<Int>? = null

    private var compressedDigitalVideoOpl: Output<Int>? = null

    private var digitalVideoOnlyContentRestriction: Output<Boolean>? = null

    private var explicitAnalogTelevisionOutputRestriction:
        Output<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs>? = null

    private var firstPlayExpiration: Output<String>? = null

    private var imageConstraintForAnalogComponentVideoRestriction: Output<Boolean>? = null

    private var imageConstraintForAnalogComputerMonitorRestriction: Output<Boolean>? = null

    private var scmsRestriction: Output<Int>? = null

    private var uncompressedDigitalAudioOpl: Output<Int>? = null

    private var uncompressedDigitalVideoOpl: Output<Int>? = null

    /**
     * @param value Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
     */
    @JvmName("lavnjdkolaghxdgh")
    public suspend fun agcAndColorStripeRestriction(`value`: Output<Int>) {
        this.agcAndColorStripeRestriction = value
    }

    /**
     * @param value Configures Unknown output handling settings of the license.
     */
    @JvmName("ifnaychbiaowajnf")
    public suspend
    fun allowPassingVideoContentToUnknownOutput(`value`: Output<Either<String, ContentKeyPolicyPlayReadyUnknownOutputPassingOption>>) {
        this.allowPassingVideoContentToUnknownOutput = value
    }

    /**
     * @param value Specifies the output protection level for compressed digital audio.
     */
    @JvmName("qrxbopmjgecagbos")
    public suspend fun analogVideoOpl(`value`: Output<Int>) {
        this.analogVideoOpl = value
    }

    /**
     * @param value Specifies the output protection level for compressed digital audio.
     */
    @JvmName("pbtyuketbyddgudd")
    public suspend fun compressedDigitalAudioOpl(`value`: Output<Int>) {
        this.compressedDigitalAudioOpl = value
    }

    /**
     * @param value Specifies the output protection level for compressed digital video.
     */
    @JvmName("twbrhblasmpycpgh")
    public suspend fun compressedDigitalVideoOpl(`value`: Output<Int>) {
        this.compressedDigitalVideoOpl = value
    }

    /**
     * @param value Enables the Image Constraint For Analog Component Video Restriction in the license.
     */
    @JvmName("esdutrgtcnvdpieq")
    public suspend fun digitalVideoOnlyContentRestriction(`value`: Output<Boolean>) {
        this.digitalVideoOnlyContentRestriction = value
    }

    /**
     * @param value Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
     */
    @JvmName("swuvkqghhumxfncc")
    public suspend
    fun explicitAnalogTelevisionOutputRestriction(`value`: Output<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs>) {
        this.explicitAnalogTelevisionOutputRestriction = value
    }

    /**
     * @param value The amount of time that the license is valid after the license is first used to play content.
     */
    @JvmName("lykrdytqiffybcyb")
    public suspend fun firstPlayExpiration(`value`: Output<String>) {
        this.firstPlayExpiration = value
    }

    /**
     * @param value Enables the Image Constraint For Analog Component Video Restriction in the license.
     */
    @JvmName("feiuxohruseymbfh")
    public suspend fun imageConstraintForAnalogComponentVideoRestriction(`value`: Output<Boolean>) {
        this.imageConstraintForAnalogComponentVideoRestriction = value
    }

    /**
     * @param value Enables the Image Constraint For Analog Component Video Restriction in the license.
     */
    @JvmName("srfbgvpghnexpkki")
    public suspend fun imageConstraintForAnalogComputerMonitorRestriction(`value`: Output<Boolean>) {
        this.imageConstraintForAnalogComputerMonitorRestriction = value
    }

    /**
     * @param value Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
     */
    @JvmName("ynpqybyadyenxfva")
    public suspend fun scmsRestriction(`value`: Output<Int>) {
        this.scmsRestriction = value
    }

    /**
     * @param value Specifies the output protection level for uncompressed digital audio.
     */
    @JvmName("vmnehnifmauriujp")
    public suspend fun uncompressedDigitalAudioOpl(`value`: Output<Int>) {
        this.uncompressedDigitalAudioOpl = value
    }

    /**
     * @param value Specifies the output protection level for uncompressed digital video.
     */
    @JvmName("tamyfobyvxqymhvf")
    public suspend fun uncompressedDigitalVideoOpl(`value`: Output<Int>) {
        this.uncompressedDigitalVideoOpl = value
    }

    /**
     * @param value Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
     */
    @JvmName("txtdmmfohaperhvt")
    public suspend fun agcAndColorStripeRestriction(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agcAndColorStripeRestriction = mapped
    }

    /**
     * @param value Configures Unknown output handling settings of the license.
     */
    @JvmName("mwtjadpdlssignxd")
    public suspend
    fun allowPassingVideoContentToUnknownOutput(`value`: Either<String, ContentKeyPolicyPlayReadyUnknownOutputPassingOption>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowPassingVideoContentToUnknownOutput = mapped
    }

    /**
     * @param value Configures Unknown output handling settings of the license.
     */
    @JvmName("teimjmuahujnqyqn")
    public fun allowPassingVideoContentToUnknownOutput(`value`: String) {
        val toBeMapped = Either.ofLeft<String,
            ContentKeyPolicyPlayReadyUnknownOutputPassingOption,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowPassingVideoContentToUnknownOutput = mapped
    }

    /**
     * @param value Configures Unknown output handling settings of the license.
     */
    @JvmName("fbkudaqnygnvqssb")
    public
    fun allowPassingVideoContentToUnknownOutput(`value`: ContentKeyPolicyPlayReadyUnknownOutputPassingOption) {
        val toBeMapped = Either.ofRight<String,
            ContentKeyPolicyPlayReadyUnknownOutputPassingOption,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowPassingVideoContentToUnknownOutput = mapped
    }

    /**
     * @param value Specifies the output protection level for compressed digital audio.
     */
    @JvmName("brwhnrhmpclywnfo")
    public suspend fun analogVideoOpl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analogVideoOpl = mapped
    }

    /**
     * @param value Specifies the output protection level for compressed digital audio.
     */
    @JvmName("upxqevcmlxqdcysi")
    public suspend fun compressedDigitalAudioOpl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressedDigitalAudioOpl = mapped
    }

    /**
     * @param value Specifies the output protection level for compressed digital video.
     */
    @JvmName("vwdynwdwtxwnuoxa")
    public suspend fun compressedDigitalVideoOpl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressedDigitalVideoOpl = mapped
    }

    /**
     * @param value Enables the Image Constraint For Analog Component Video Restriction in the license.
     */
    @JvmName("asaglnlkdvbdogml")
    public suspend fun digitalVideoOnlyContentRestriction(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.digitalVideoOnlyContentRestriction = mapped
    }

    /**
     * @param value Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
     */
    @JvmName("rstmytatbdmkjngg")
    public suspend
    fun explicitAnalogTelevisionOutputRestriction(`value`: ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.explicitAnalogTelevisionOutputRestriction = mapped
    }

    /**
     * @param argument Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
     */
    @JvmName("cxqomaldyihmsxfx")
    public suspend
    fun explicitAnalogTelevisionOutputRestriction(argument: suspend ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.explicitAnalogTelevisionOutputRestriction = mapped
    }

    /**
     * @param value The amount of time that the license is valid after the license is first used to play content.
     */
    @JvmName("ehfqlkbjbsrjkewb")
    public suspend fun firstPlayExpiration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstPlayExpiration = mapped
    }

    /**
     * @param value Enables the Image Constraint For Analog Component Video Restriction in the license.
     */
    @JvmName("vtvldtxrmmuaghqc")
    public suspend fun imageConstraintForAnalogComponentVideoRestriction(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageConstraintForAnalogComponentVideoRestriction = mapped
    }

    /**
     * @param value Enables the Image Constraint For Analog Component Video Restriction in the license.
     */
    @JvmName("xdafothmjyruiydk")
    public suspend fun imageConstraintForAnalogComputerMonitorRestriction(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageConstraintForAnalogComputerMonitorRestriction = mapped
    }

    /**
     * @param value Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
     */
    @JvmName("bsvxhbhbiwxsduec")
    public suspend fun scmsRestriction(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmsRestriction = mapped
    }

    /**
     * @param value Specifies the output protection level for uncompressed digital audio.
     */
    @JvmName("admlsvduqolqixqh")
    public suspend fun uncompressedDigitalAudioOpl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uncompressedDigitalAudioOpl = mapped
    }

    /**
     * @param value Specifies the output protection level for uncompressed digital video.
     */
    @JvmName("dbacobptibieeifp")
    public suspend fun uncompressedDigitalVideoOpl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uncompressedDigitalVideoOpl = mapped
    }

    internal fun build(): ContentKeyPolicyPlayReadyPlayRightArgs =
        ContentKeyPolicyPlayReadyPlayRightArgs(
            agcAndColorStripeRestriction = agcAndColorStripeRestriction,
            allowPassingVideoContentToUnknownOutput = allowPassingVideoContentToUnknownOutput ?: throw
                PulumiNullFieldException("allowPassingVideoContentToUnknownOutput"),
            analogVideoOpl = analogVideoOpl,
            compressedDigitalAudioOpl = compressedDigitalAudioOpl,
            compressedDigitalVideoOpl = compressedDigitalVideoOpl,
            digitalVideoOnlyContentRestriction = digitalVideoOnlyContentRestriction ?: throw
                PulumiNullFieldException("digitalVideoOnlyContentRestriction"),
            explicitAnalogTelevisionOutputRestriction = explicitAnalogTelevisionOutputRestriction,
            firstPlayExpiration = firstPlayExpiration,
            imageConstraintForAnalogComponentVideoRestriction = imageConstraintForAnalogComponentVideoRestriction
                ?: throw PulumiNullFieldException("imageConstraintForAnalogComponentVideoRestriction"),
            imageConstraintForAnalogComputerMonitorRestriction = imageConstraintForAnalogComputerMonitorRestriction
                ?: throw PulumiNullFieldException("imageConstraintForAnalogComputerMonitorRestriction"),
            scmsRestriction = scmsRestriction,
            uncompressedDigitalAudioOpl = uncompressedDigitalAudioOpl,
            uncompressedDigitalVideoOpl = uncompressedDigitalVideoOpl,
        )
}
