@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicySymmetricTokenKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies a symmetric key for token validation.
 * @property keyValue The key value of the key
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
 */
public data class ContentKeyPolicySymmetricTokenKeyArgs(
    public val keyValue: Output<String>,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicySymmetricTokenKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicySymmetricTokenKeyArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicySymmetricTokenKeyArgs.builder()
            .keyValue(keyValue.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicySymmetricTokenKeyArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicySymmetricTokenKeyArgsBuilder internal constructor() {
    private var keyValue: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The key value of the key
     */
    @JvmName("qfmrviamedtyilpd")
    public suspend fun keyValue(`value`: Output<String>) {
        this.keyValue = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
     */
    @JvmName("pvsydmndmkprgalp")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The key value of the key
     */
    @JvmName("dahrmxejbdlpfmex")
    public suspend fun keyValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyValue = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
     */
    @JvmName("vanicvbwavtlgxbl")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ContentKeyPolicySymmetricTokenKeyArgs =
        ContentKeyPolicySymmetricTokenKeyArgs(
            keyValue = keyValue ?: throw PulumiNullFieldException("keyValue"),
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        )
}
