@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyTokenRestrictionArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.ContentKeyPolicyRestrictionTokenType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
 * @property alternateVerificationKeys A list of alternative verification keys.
 * @property audience The audience for the token.
 * @property issuer The token issuer.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
 * @property openIdConnectDiscoveryDocument The OpenID connect discovery document.
 * @property primaryVerificationKey The primary verification key.
 * @property requiredClaims A list of required token claims.
 * @property restrictionTokenType The type of token.
 */
public data class ContentKeyPolicyTokenRestrictionArgs(
    public val alternateVerificationKeys: Output<List<Any>>? = null,
    public val audience: Output<String>,
    public val issuer: Output<String>,
    public val odataType: Output<String>,
    public val openIdConnectDiscoveryDocument: Output<String>? = null,
    public val primaryVerificationKey: Output<Any>,
    public val requiredClaims: Output<List<ContentKeyPolicyTokenClaimArgs>>? = null,
    public val restrictionTokenType: Output<Either<String, ContentKeyPolicyRestrictionTokenType>>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyTokenRestrictionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyTokenRestrictionArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyTokenRestrictionArgs.builder()
            .alternateVerificationKeys(
                alternateVerificationKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .audience(audience.applyValue({ args0 -> args0 }))
            .issuer(issuer.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .openIdConnectDiscoveryDocument(openIdConnectDiscoveryDocument?.applyValue({ args0 -> args0 }))
            .primaryVerificationKey(primaryVerificationKey.applyValue({ args0 -> args0 }))
            .requiredClaims(
                requiredClaims?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .restrictionTokenType(
                restrictionTokenType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ContentKeyPolicyTokenRestrictionArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyTokenRestrictionArgsBuilder internal constructor() {
    private var alternateVerificationKeys: Output<List<Any>>? = null

    private var audience: Output<String>? = null

    private var issuer: Output<String>? = null

    private var odataType: Output<String>? = null

    private var openIdConnectDiscoveryDocument: Output<String>? = null

    private var primaryVerificationKey: Output<Any>? = null

    private var requiredClaims: Output<List<ContentKeyPolicyTokenClaimArgs>>? = null

    private var restrictionTokenType: Output<Either<String, ContentKeyPolicyRestrictionTokenType>>? =
        null

    /**
     * @param value A list of alternative verification keys.
     */
    @JvmName("jhoqytllpouxnehe")
    public suspend fun alternateVerificationKeys(`value`: Output<List<Any>>) {
        this.alternateVerificationKeys = value
    }

    @JvmName("unxpdqndtptiliny")
    public suspend fun alternateVerificationKeys(vararg values: Output<Any>) {
        this.alternateVerificationKeys = Output.all(values.asList())
    }

    /**
     * @param values A list of alternative verification keys.
     */
    @JvmName("uhxfqxwnjaolgpsd")
    public suspend fun alternateVerificationKeys(values: List<Output<Any>>) {
        this.alternateVerificationKeys = Output.all(values)
    }

    /**
     * @param value The audience for the token.
     */
    @JvmName("nssqjomidrydxrbh")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value The token issuer.
     */
    @JvmName("txeawhcrxktiyxfj")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
     */
    @JvmName("jjjajcqehmwbjgga")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The OpenID connect discovery document.
     */
    @JvmName("eioneijuknsflybu")
    public suspend fun openIdConnectDiscoveryDocument(`value`: Output<String>) {
        this.openIdConnectDiscoveryDocument = value
    }

    /**
     * @param value The primary verification key.
     */
    @JvmName("bsmidvknrsxtoagp")
    public suspend fun primaryVerificationKey(`value`: Output<Any>) {
        this.primaryVerificationKey = value
    }

    /**
     * @param value A list of required token claims.
     */
    @JvmName("qxubvgowecghdfly")
    public suspend fun requiredClaims(`value`: Output<List<ContentKeyPolicyTokenClaimArgs>>) {
        this.requiredClaims = value
    }

    @JvmName("kspghutipctamsrk")
    public suspend fun requiredClaims(vararg values: Output<ContentKeyPolicyTokenClaimArgs>) {
        this.requiredClaims = Output.all(values.asList())
    }

    /**
     * @param values A list of required token claims.
     */
    @JvmName("mrxantcqyppvhket")
    public suspend fun requiredClaims(values: List<Output<ContentKeyPolicyTokenClaimArgs>>) {
        this.requiredClaims = Output.all(values)
    }

    /**
     * @param value The type of token.
     */
    @JvmName("oksatmsegbugodei")
    public suspend
    fun restrictionTokenType(`value`: Output<Either<String, ContentKeyPolicyRestrictionTokenType>>) {
        this.restrictionTokenType = value
    }

    /**
     * @param value A list of alternative verification keys.
     */
    @JvmName("bwiqhyttekwfwafs")
    public suspend fun alternateVerificationKeys(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternateVerificationKeys = mapped
    }

    /**
     * @param values A list of alternative verification keys.
     */
    @JvmName("sdhqmpuhfqmedtfw")
    public suspend fun alternateVerificationKeys(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alternateVerificationKeys = mapped
    }

    /**
     * @param value The audience for the token.
     */
    @JvmName("oaarwfonalarlnyy")
    public suspend fun audience(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value The token issuer.
     */
    @JvmName("karlwdsukfyobqso")
    public suspend fun issuer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
     */
    @JvmName("ykdvfhxrjtmvmjrw")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The OpenID connect discovery document.
     */
    @JvmName("suffmamuexrkmavf")
    public suspend fun openIdConnectDiscoveryDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openIdConnectDiscoveryDocument = mapped
    }

    /**
     * @param value The primary verification key.
     */
    @JvmName("lwjljvertxhkamlo")
    public suspend fun primaryVerificationKey(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryVerificationKey = mapped
    }

    /**
     * @param value A list of required token claims.
     */
    @JvmName("lhaygtmkbrnbruxy")
    public suspend fun requiredClaims(`value`: List<ContentKeyPolicyTokenClaimArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredClaims = mapped
    }

    /**
     * @param argument A list of required token claims.
     */
    @JvmName("hcohfhvenuulfyiw")
    public suspend
    fun requiredClaims(argument: List<suspend ContentKeyPolicyTokenClaimArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContentKeyPolicyTokenClaimArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requiredClaims = mapped
    }

    /**
     * @param argument A list of required token claims.
     */
    @JvmName("tyrxveumsrrxlmlc")
    public suspend fun requiredClaims(
        vararg
        argument: suspend ContentKeyPolicyTokenClaimArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContentKeyPolicyTokenClaimArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requiredClaims = mapped
    }

    /**
     * @param argument A list of required token claims.
     */
    @JvmName("iurmnqpwcwvnfldo")
    public suspend
    fun requiredClaims(argument: suspend ContentKeyPolicyTokenClaimArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContentKeyPolicyTokenClaimArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.requiredClaims = mapped
    }

    /**
     * @param values A list of required token claims.
     */
    @JvmName("lgibpkydnyilvlpj")
    public suspend fun requiredClaims(vararg values: ContentKeyPolicyTokenClaimArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredClaims = mapped
    }

    /**
     * @param value The type of token.
     */
    @JvmName("parvdruljtuccarc")
    public suspend
    fun restrictionTokenType(`value`: Either<String, ContentKeyPolicyRestrictionTokenType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictionTokenType = mapped
    }

    /**
     * @param value The type of token.
     */
    @JvmName("fqvkfobthraaoaqu")
    public fun restrictionTokenType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentKeyPolicyRestrictionTokenType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictionTokenType = mapped
    }

    /**
     * @param value The type of token.
     */
    @JvmName("usmncwgrvqcslqlk")
    public fun restrictionTokenType(`value`: ContentKeyPolicyRestrictionTokenType) {
        val toBeMapped = Either.ofRight<String, ContentKeyPolicyRestrictionTokenType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictionTokenType = mapped
    }

    internal fun build(): ContentKeyPolicyTokenRestrictionArgs = ContentKeyPolicyTokenRestrictionArgs(
        alternateVerificationKeys = alternateVerificationKeys,
        audience = audience ?: throw PulumiNullFieldException("audience"),
        issuer = issuer ?: throw PulumiNullFieldException("issuer"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        openIdConnectDiscoveryDocument = openIdConnectDiscoveryDocument,
        primaryVerificationKey = primaryVerificationKey ?: throw
            PulumiNullFieldException("primaryVerificationKey"),
        requiredClaims = requiredClaims,
        restrictionTokenType = restrictionTokenType ?: throw
            PulumiNullFieldException("restrictionTokenType"),
    )
}
