@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyWidevineConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies a configuration for Widevine licenses.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
 * @property widevineTemplate The Widevine template.
 */
public data class ContentKeyPolicyWidevineConfigurationArgs(
    public val odataType: Output<String>,
    public val widevineTemplate: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyWidevineConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyWidevineConfigurationArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyWidevineConfigurationArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .widevineTemplate(widevineTemplate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyWidevineConfigurationArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyWidevineConfigurationArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    private var widevineTemplate: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
     */
    @JvmName("yiqsqaldbkclupea")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The Widevine template.
     */
    @JvmName("jxmryafkrwglswqe")
    public suspend fun widevineTemplate(`value`: Output<String>) {
        this.widevineTemplate = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
     */
    @JvmName("cdaqijtljderdgyb")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The Widevine template.
     */
    @JvmName("jwkqrvmpgbmwdxpt")
    public suspend fun widevineTemplate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.widevineTemplate = mapped
    }

    internal fun build(): ContentKeyPolicyWidevineConfigurationArgs =
        ContentKeyPolicyWidevineConfigurationArgs(
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
            widevineTemplate = widevineTemplate ?: throw PulumiNullFieldException("widevineTemplate"),
        )
}
