@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.EnvelopeEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class for EnvelopeEncryption encryption scheme
 * @property clearTracks Representing which tracks should not be encrypted
 * @property contentKeys Representing default content key for each encryption scheme and separate content keys for specific tracks
 * @property customKeyAcquisitionUrlTemplate Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
 * @property enabledProtocols Representing supported protocols
 */
public data class EnvelopeEncryptionArgs(
    public val clearTracks: Output<List<TrackSelectionArgs>>? = null,
    public val contentKeys: Output<StreamingPolicyContentKeysArgs>? = null,
    public val customKeyAcquisitionUrlTemplate: Output<String>? = null,
    public val enabledProtocols: Output<EnabledProtocolsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.EnvelopeEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.EnvelopeEncryptionArgs =
        com.pulumi.azurenative.media.inputs.EnvelopeEncryptionArgs.builder()
            .clearTracks(
                clearTracks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .contentKeys(contentKeys?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customKeyAcquisitionUrlTemplate(customKeyAcquisitionUrlTemplate?.applyValue({ args0 -> args0 }))
            .enabledProtocols(
                enabledProtocols?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EnvelopeEncryptionArgs].
 */
@PulumiTagMarker
public class EnvelopeEncryptionArgsBuilder internal constructor() {
    private var clearTracks: Output<List<TrackSelectionArgs>>? = null

    private var contentKeys: Output<StreamingPolicyContentKeysArgs>? = null

    private var customKeyAcquisitionUrlTemplate: Output<String>? = null

    private var enabledProtocols: Output<EnabledProtocolsArgs>? = null

    /**
     * @param value Representing which tracks should not be encrypted
     */
    @JvmName("wwrrfqullfkxwxkb")
    public suspend fun clearTracks(`value`: Output<List<TrackSelectionArgs>>) {
        this.clearTracks = value
    }

    @JvmName("lpyladghfaofiudk")
    public suspend fun clearTracks(vararg values: Output<TrackSelectionArgs>) {
        this.clearTracks = Output.all(values.asList())
    }

    /**
     * @param values Representing which tracks should not be encrypted
     */
    @JvmName("uivhqqkvqnfudryq")
    public suspend fun clearTracks(values: List<Output<TrackSelectionArgs>>) {
        this.clearTracks = Output.all(values)
    }

    /**
     * @param value Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("apqleeatfkcgkmtb")
    public suspend fun contentKeys(`value`: Output<StreamingPolicyContentKeysArgs>) {
        this.contentKeys = value
    }

    /**
     * @param value Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
     */
    @JvmName("kwqdciytfieeprwx")
    public suspend fun customKeyAcquisitionUrlTemplate(`value`: Output<String>) {
        this.customKeyAcquisitionUrlTemplate = value
    }

    /**
     * @param value Representing supported protocols
     */
    @JvmName("whobbbofuqmauobf")
    public suspend fun enabledProtocols(`value`: Output<EnabledProtocolsArgs>) {
        this.enabledProtocols = value
    }

    /**
     * @param value Representing which tracks should not be encrypted
     */
    @JvmName("uslmyqudbnjikxlx")
    public suspend fun clearTracks(`value`: List<TrackSelectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("tpjldvsgdvkxlnhv")
    public suspend fun clearTracks(argument: List<suspend TrackSelectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("uhsyowiosrnvomii")
    public suspend fun clearTracks(vararg argument: suspend TrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param argument Representing which tracks should not be encrypted
     */
    @JvmName("hlwtivxivvcjndxf")
    public suspend fun clearTracks(argument: suspend TrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrackSelectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clearTracks = mapped
    }

    /**
     * @param values Representing which tracks should not be encrypted
     */
    @JvmName("cojmgyuvdssswljy")
    public suspend fun clearTracks(vararg values: TrackSelectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clearTracks = mapped
    }

    /**
     * @param value Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("ngttcrrlyptwgpik")
    public suspend fun contentKeys(`value`: StreamingPolicyContentKeysArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentKeys = mapped
    }

    /**
     * @param argument Representing default content key for each encryption scheme and separate content keys for specific tracks
     */
    @JvmName("fdhaderxwbxillku")
    public suspend
    fun contentKeys(argument: suspend StreamingPolicyContentKeysArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingPolicyContentKeysArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contentKeys = mapped
    }

    /**
     * @param value Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
     */
    @JvmName("nryreacfixcnbtax")
    public suspend fun customKeyAcquisitionUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customKeyAcquisitionUrlTemplate = mapped
    }

    /**
     * @param value Representing supported protocols
     */
    @JvmName("rcdohrxuskwqnaxp")
    public suspend fun enabledProtocols(`value`: EnabledProtocolsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledProtocols = mapped
    }

    /**
     * @param argument Representing supported protocols
     */
    @JvmName("hgphqwdqkmqejtpn")
    public suspend fun enabledProtocols(argument: suspend EnabledProtocolsArgsBuilder.() -> Unit) {
        val toBeMapped = EnabledProtocolsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enabledProtocols = mapped
    }

    internal fun build(): EnvelopeEncryptionArgs = EnvelopeEncryptionArgs(
        clearTracks = clearTracks,
        contentKeys = contentKeys,
        customKeyAcquisitionUrlTemplate = customKeyAcquisitionUrlTemplate,
        enabledProtocols = enabledProtocols,
    )
}
