@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.FiltersArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.Rotation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.
 * @property crop The parameters for the rectangular window with which to crop the input video.
 * @property deinterlace The de-interlacing settings.
 * @property fadeIn Describes the properties of a Fade effect applied to the input media.
 * @property fadeOut Describes the properties of a Fade effect applied to the input media.
 * @property overlays The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
 * @property rotation The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
 */
public data class FiltersArgs(
    public val crop: Output<RectangleArgs>? = null,
    public val deinterlace: Output<DeinterlaceArgs>? = null,
    public val fadeIn: Output<FadeArgs>? = null,
    public val fadeOut: Output<FadeArgs>? = null,
    public val overlays: Output<List<Either<AudioOverlayArgs, VideoOverlayArgs>>>? = null,
    public val rotation: Output<Either<String, Rotation>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.FiltersArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.FiltersArgs =
        com.pulumi.azurenative.media.inputs.FiltersArgs.builder()
            .crop(crop?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deinterlace(deinterlace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fadeIn(fadeIn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fadeOut(fadeOut?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .overlays(
                overlays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .rotation(
                rotation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FiltersArgs].
 */
@PulumiTagMarker
public class FiltersArgsBuilder internal constructor() {
    private var crop: Output<RectangleArgs>? = null

    private var deinterlace: Output<DeinterlaceArgs>? = null

    private var fadeIn: Output<FadeArgs>? = null

    private var fadeOut: Output<FadeArgs>? = null

    private var overlays: Output<List<Either<AudioOverlayArgs, VideoOverlayArgs>>>? = null

    private var rotation: Output<Either<String, Rotation>>? = null

    /**
     * @param value The parameters for the rectangular window with which to crop the input video.
     */
    @JvmName("nsvjkmdnmgkuompt")
    public suspend fun crop(`value`: Output<RectangleArgs>) {
        this.crop = value
    }

    /**
     * @param value The de-interlacing settings.
     */
    @JvmName("pqfjngnggqeyfigy")
    public suspend fun deinterlace(`value`: Output<DeinterlaceArgs>) {
        this.deinterlace = value
    }

    /**
     * @param value Describes the properties of a Fade effect applied to the input media.
     */
    @JvmName("prflvjocfmabgroh")
    public suspend fun fadeIn(`value`: Output<FadeArgs>) {
        this.fadeIn = value
    }

    /**
     * @param value Describes the properties of a Fade effect applied to the input media.
     */
    @JvmName("cbncyetwjvxjdmdl")
    public suspend fun fadeOut(`value`: Output<FadeArgs>) {
        this.fadeOut = value
    }

    /**
     * @param value The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
     */
    @JvmName("nxngifphmvfrdayg")
    public suspend fun overlays(`value`: Output<List<Either<AudioOverlayArgs, VideoOverlayArgs>>>) {
        this.overlays = value
    }

    @JvmName("vovwxkeektutnpge")
    public suspend fun overlays(vararg values: Output<Either<AudioOverlayArgs, VideoOverlayArgs>>) {
        this.overlays = Output.all(values.asList())
    }

    /**
     * @param values The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
     */
    @JvmName("mqnjqontdaeioqdv")
    public suspend fun overlays(values: List<Output<Either<AudioOverlayArgs, VideoOverlayArgs>>>) {
        this.overlays = Output.all(values)
    }

    /**
     * @param value The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
     */
    @JvmName("mvloxofthxnuwaed")
    public suspend fun rotation(`value`: Output<Either<String, Rotation>>) {
        this.rotation = value
    }

    /**
     * @param value The parameters for the rectangular window with which to crop the input video.
     */
    @JvmName("lsjttawpviktttat")
    public suspend fun crop(`value`: RectangleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crop = mapped
    }

    /**
     * @param argument The parameters for the rectangular window with which to crop the input video.
     */
    @JvmName("wxmxrbrogxjjfqpn")
    public suspend fun crop(argument: suspend RectangleArgsBuilder.() -> Unit) {
        val toBeMapped = RectangleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.crop = mapped
    }

    /**
     * @param value The de-interlacing settings.
     */
    @JvmName("ljpfpcfftxbsqama")
    public suspend fun deinterlace(`value`: DeinterlaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deinterlace = mapped
    }

    /**
     * @param argument The de-interlacing settings.
     */
    @JvmName("qciqjfhjkfincncv")
    public suspend fun deinterlace(argument: suspend DeinterlaceArgsBuilder.() -> Unit) {
        val toBeMapped = DeinterlaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deinterlace = mapped
    }

    /**
     * @param value Describes the properties of a Fade effect applied to the input media.
     */
    @JvmName("wpvaujwbixnyedvp")
    public suspend fun fadeIn(`value`: FadeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fadeIn = mapped
    }

    /**
     * @param argument Describes the properties of a Fade effect applied to the input media.
     */
    @JvmName("ghvttvlijmkswiis")
    public suspend fun fadeIn(argument: suspend FadeArgsBuilder.() -> Unit) {
        val toBeMapped = FadeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fadeIn = mapped
    }

    /**
     * @param value Describes the properties of a Fade effect applied to the input media.
     */
    @JvmName("fstrdgxwonjwuyrc")
    public suspend fun fadeOut(`value`: FadeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fadeOut = mapped
    }

    /**
     * @param argument Describes the properties of a Fade effect applied to the input media.
     */
    @JvmName("yrfixguiwshjdfhs")
    public suspend fun fadeOut(argument: suspend FadeArgsBuilder.() -> Unit) {
        val toBeMapped = FadeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fadeOut = mapped
    }

    /**
     * @param value The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
     */
    @JvmName("guakskfeeqctjwum")
    public suspend fun overlays(`value`: List<Either<AudioOverlayArgs, VideoOverlayArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overlays = mapped
    }

    /**
     * @param values The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
     */
    @JvmName("qiaogohlsmqqpwom")
    public suspend fun overlays(vararg values: Either<AudioOverlayArgs, VideoOverlayArgs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overlays = mapped
    }

    /**
     * @param value The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
     */
    @JvmName("niwmfufbiopfugog")
    public suspend fun rotation(`value`: Either<String, Rotation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotation = mapped
    }

    /**
     * @param value The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
     */
    @JvmName("iuyurtxmvuiofwvf")
    public fun rotation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Rotation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rotation = mapped
    }

    /**
     * @param value The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
     */
    @JvmName("ncpqisfkssgojanc")
    public fun rotation(`value`: Rotation) {
        val toBeMapped = Either.ofRight<String, Rotation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rotation = mapped
    }

    internal fun build(): FiltersArgs = FiltersArgs(
        crop = crop,
        deinterlace = deinterlace,
        fadeIn = fadeIn,
        fadeOut = fadeOut,
        overlays = overlays,
        rotation = rotation,
    )
}
