@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property jobName The Job name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property transformName The Transform name.
 */
public data class GetJobPlainArgs(
    public val accountName: String,
    public val jobName: String,
    public val resourceGroupName: String,
    public val transformName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetJobPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetJobPlainArgs =
        com.pulumi.azurenative.media.inputs.GetJobPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .transformName(transformName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobPlainArgs].
 */
@PulumiTagMarker
public class GetJobPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var jobName: String? = null

    private var resourceGroupName: String? = null

    private var transformName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("hgwshdccvhhckxsb")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Job name.
     */
    @JvmName("kptcrcjilhmremcg")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("ghmmctqgesctgwxj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Transform name.
     */
    @JvmName("wjegdyqtiansowjn")
    public suspend fun transformName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transformName = mapped
    }

    internal fun build(): GetJobPlainArgs = GetJobPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        transformName = transformName ?: throw PulumiNullFieldException("transformName"),
    )
}
